package cn.breeze.elleai.util;

import cn.breeze.elleai.config.MinioFileProperties;
import cn.breeze.elleai.exception.InternalException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.smartbreeze.core.file.client.MinioFileClient;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.InputStream;

@Slf4j
@Component
@RequiredArgsConstructor
public class PrivateFileService {

    private final MinioFileClient minioFileClient;

    private final MinioFileProperties fileProperties;

    public String upload(String filename, File file) {
        return upload(filename, IoUtil.toStream(file));
    }

    public String upload(String key, InputStream inputStream) {
        String[] url = {null};

        minioFileClient.uploadFile(key, inputStream)
                .doOnError(e -> {
                    log.error("上传文件失败", e);
                    throw new InternalException(1000, "上传文件失败");
                })
                .subscribe(res -> {
                    url[0] = res.getUrl();
                });
        return url[0];
    }

    public String getPrefix() {
        return null;
    }

    public InputStream getFileInputStream(String key) {
        return minioFileClient.getFileByKey(key).block();
    }


    public String getPrivateFileUrlForDownload(String key) {
        if (StrUtil.isBlank(key)) {
            return "";
        }

        String prefix = fileProperties.getUploadPrefix();
        prefix = StrUtil.isBlank(prefix) ? "" : prefix;

        if (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }

        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }

        if (key.startsWith("/")) {
            key = key.substring(1);
        }

        String query = prefix.concat("/").concat(key);

        return StrUtil.nullToEmpty(fileProperties.getDownloadUrlPrefix()) + "admin/common/getfile?fn=" + query;
    }
}
