# Начало работы

## Vue CLI

Если вы не заинтересованы настраивать вручную webpack, тогда мы рекомендуем вам разворачивать проекты с помощью [Vue CLI](https://github.com/vuejs/vue-cli). Проекты создаваемые с помощью Vue CLI предварительно сконфигурированы с учётом большинства общих потребностей при разработке из коробки.

Следуйте этому руководству, если встроенная конфигурация Vue CLI не подходит для ваших нужд, или вы предпочитаете создавать собственную конфигурацию webpack с нуля.

## Настройка вручную

### Установка

Если вы не продвинутый пользователь, использующий собственную форкнутую версию компилятора шаблонов Vue, то должны установить `vue-loader` и `vue-template-compiler` вместе:

``` bash
npm install -D vue-loader vue-template-compiler
```

Причина, по которой `vue-template-compiler` требуется устанавливать отдельно в том, что можно отдельно указать его версию.

Каждый раз, когда выходит новая версия `vue`, выпускается и соответствующая версия `vue-template-compiler`. Версия компилятора должна быть аналогичной версии базового пакета `vue`, чтобы `vue-loader` генерировал код совместимый с runtime. Поэтому **каждый раз, когда вы обновляете `vue` в проекте, вы должны также обновить и `vue-template-compiler` до такой же версии.**

 ### Конфигурация webpack

Конфигурация Vue Loader немного отличается от настройки других загрузчиков. В дополнении к правилу, которое будет применять `vue-loader` ко всем файлам с расширением `.vue`, убедитесь что добавили плагин Vue Loader в вашу конфигурацию webpack:

``` js
// webpack.config.js
const VueLoaderPlugin = require('vue-loader/lib/plugin')

module.exports = {
  module: {
    rules: [
      // ... другие правила
      {
        test: /\.vue$/,
        loader: 'vue-loader'
      }
    ]
  },
  plugins: [
    // убедитесь что подключили плагин!
    new VueLoaderPlugin()
  ]
}
```

**Плагин необходим!** Он отвечает за клонирование любых других правил, которые вы определили, чтобы применить их к соответствующим языковым блокам в файлах `.vue`. Например, если у вас есть правило, соответствующее файлам `/\.js$/`, оно будет применяться к секциям `<script>` в файлах `.vue`.

Более полная версия конфигурации webpack будет выглядеть так:

``` js
// webpack.config.js
const VueLoaderPlugin = require('vue-loader/lib/plugin')

module.exports = {
  mode: 'development',
  module: {
    rules: [
      {
        test: /\.vue$/,
        loader: 'vue-loader'
      },
      // это будет применяться к файлам `.js`
      // А ТАКЖЕ к секциям `<script>` внутри файлов `.vue`
      {
        test: /\.js$/,
        loader: 'babel-loader'
      },
      // это будет применяться к файлам `.css`
      // А ТАКЖЕ к секциям `<style>` внутри файлов `.vue`
      {
        test: /\.css$/,
        use: [
          'vue-style-loader',
          'css-loader'
        ]
      }
    ]
  },
  plugins: [
    // убедитесь что подключили плагин!
    new VueLoaderPlugin()
  ]
}
```

Также смотрите [перечень настроек](../options.md), где перечислены все доступные опции загрузчика.

::: warning ВНИМАНИЕ
При разработке библиотеки или работе в монорепозитории, имейте ввиду, что импорты CSS **являются сайд-эффектами**. Убедитесь, что **удалили** `"sideEffects": false` в `package.json`, в противном случае фрагменты CSS будут удалены webpack в сборках для production.
:::
