# Обработка вложенных URL

Когда Vue Loader компилирует секции `<template>` в однофайловых компонентах, то он будет трактовать все использованные URL как **зависимости модуля**.

Например, следующий примера шаблона:

``` vue
<img src="../image.png">
```

будет скомпилирован в:

``` js
createElement('img', {
  attrs: {
    src: require('../image.png') // теперь это запрос к модулю
  }
})
```

По умолчанию следующие комбинации тегов/атрибутов преобразуются и могут быть настроены с помощью опции [transformAssetUrls](../options.md#transformasseturls).

``` js
{
  video: ['src', 'poster'],
  source: 'src',
  img: 'src',
  image: ['xlink:href', 'href'],
  use: ['xlink:href', 'href']
}
```

Кроме того, если вы настроили использование [css-loader](https://github.com/webpack-contrib/css-loader) для секций `<style>`, используемые URL-адреса в вашем CSS будут обрабатываться аналогичным образом.

## Правила преобразования

Преобразования URL ресурсов подчиняются следующим правилам:

- Если в URL абсолютный путь (например, `/images/foo.png`), он будет оставлен как есть.

- Если URL начинается с `.`, он будет истолковываться как запрос модуля относительно текущего каталога и разрешаться на основе структуры каталогов вашей файловой системы.

- Если URL начинается с `~`, то всё что после него будет истолковываться как запрос модуля. Это означает, что вы можете ссылаться на ресурсы даже внутри node_modules:

  ``` html
  <img src="~some-npm-package/foo.png">
  ```

- Если URL начинается с `@`, то также будет истолковываться как запрос модуля. Это полезно если в вашей конфигурации webpack есть псевдоним для `@`, который по умолчанию указывает на `/src` в любом проекте, созданном через `vue-cli`.

## Связанные загрузчики

Так как файлы с расширениями, таким как `.png`, не являются JavaScript- модулями, вам необходимо настроить webpack для использования [file-loader](https://github.com/webpack/file-loader) или [url-loader](https://github.com/webpack/url-loader) чтобы корректно их обрабатывать. Проекты создаваемые с помощью Vue CLI уже предварительно настраивают это для вас.

## Почему так

Преимущества подобных преобразований URL:

1. `file-loader` позволяет определить куда нужно скопировать и поместить файл, а также как именовать его, добавляя в имя хэш для лучшего кеширования. Кроме того, это означает что **вы можете просто поместить изображения рядом с вашим `*.vue` файлами и использовать относительные пути, основанные на структуре каталогов, не беспокоясь об адресах при публикации**. При правильной конфигурации, webpack будет автоматически заменять пути к файлам на корректные URL в итоговой сборке.

2. `url-loader` позволяет вставлять файлы как base-64 ссылки, если они меньше указанного размера. Это позволит уменьшить количество HTTP-запросов при использовании маленьких файлов. Если же файл больше указанного порога, то он автоматически подключится с помощью `file-loader`.
