# Функциональные компоненты

Функциональные компоненты, объявленные как однофайловые компоненты в файле `*.vue`, также получают правильную поддержку компиляции шаблона, локальный CSS и поддержку горячей перезагрузки.

Чтобы обозначить шаблон, который должен быть скомпилирован как функциональный компонент, добавьте атрибут `functional` в тег шаблона. Это также позволяет опустить опцию `functional` в теге `<script>`.

Выражения в шаблоне исполняются в [контексте функционального рендеринга](https://ru.vuejs.org/v2/guide/render-function.html#Функциональные-компоненты). Это означает, что обращаться к входным параметрам в шаблоне следует через `props.xxx`:

``` vue
<template functional>
  <div>{{ props.foo }}</div>
</template>
```

Если вам необходимо получить доступ к свойствам, определённым глобально в `Vue.prototype`, вы можете получить к ним доступ через `parent`:

``` vue
<template functional>
  <div>{{ parent.$someProperty }}</div>
</template>
```
