# Горячая перезагрузка

"Горячая перезагрузка" это не просто обновление страницы, когда вы отредактируете файл. При использовании горячей перезагрузки, когда вы отредактируете `*.vue` файл, все экземпляры этого компонента будут заменены **без перезагрузки страницы**. При этом даже будет сохранено текущее состояние вашего приложения и заменяемых компонентов! Это значительно улучшает процесс разработки, особенно когда вы занимаетесь тонкой настройкой шаблонов или стилей ваших компонентов.

![hot-reload](/hot-reload.gif)

## Правила сохранения состояния

- При редактировании `<template>` компонента, экземпляры изменённого компонента будут повторно отрендерены, сохраняя всё текущее собственное состояние. Это возможно, потому что шаблоны компилируются в новые render-функции, которые не создают побочных эффектов.

- При редактировании `<script>` компонента, экземпляры редактируемого компонента будут уничтожены и созданы заново (состояние других компонентов в приложении сохраняется). Это связано с тем, что `<script>` может включать в себя хуки жизненного цикла, которые могут создавать побочные эффекты, поэтому для обеспечения согласованности поведения требуется "перезагрузка", а не просто повторный рендеринг. Это также означает, что вам нужно быть осторожным в отношении глобальных побочных эффектов, например использования таймеров внутри хуков жизненного цикла компонентов. Иногда вам может потребоваться полная перезагрузка страницы, если ваш компонент создаёт глобальные побочные эффекты.

- Горячая перезагрузка `<style>` работает самостоятельно через `vue-style-loader`, поэтому никак не затрагивает состояние приложения.

## Использование

При создании проекта с помощью `vue-cli`, горячая перезагрузка включена по умолчанию.

При настройке проекта вручную горячая перезагрузка включится автоматически, когда вы запускаете ваш проект с помощью `webpack-dev-server --hot`.

Продвинутые пользователи могут изучить [vue-hot-reload-api](https://github.com/vuejs/vue-hot-reload-api), который используется внутри `vue-loader`.

## Отключение горячей перезагрузки

Горячая перезагрузка всегда включена, за исключением следующих ситуаций:

 * опция webpack `target` в значении `node` (SSR)
 * webpack минифицирует код
 * `process.env.NODE_ENV === 'production'`

Вы можете использовать опцию `hotReload: false` для принудительного выключения горячей перезагрузки:

``` js
module: {
  rules: [
    {
      test: /\.vue$/,
      loader: 'vue-loader',
      options: {
        hotReload: false // отключает горячую перезагрузку
      }
    }
  ]
}
```
