# Введение

:::tip ПРИМЕЧАНИЕ К ВЕРСИИ
Это документация для Vue Loader v15 и выше. Если вы обновляетесь с v14 или более ранних версий, обратитесь к [руководству по миграции](./migrating.md). Если вы используете старую версию, то документация к ней [здесь](https://vue-loader-v14.vuejs.org).
:::

## Что такое Vue Loader?

`vue-loader` — это загрузчик для [webpack](https://webpack.js.org/), который позволяет вам использовать компоненты Vue в формате, именуемым [однофайловыми компонентами](./spec.md):

``` vue
<template>
  <div class="example">{{ msg }}</div>
</template>

<script>
export default {
  data () {
    return {
      msg: 'Hello world!'
    }
  }
}
</script>

<style>
.example {
  color: red;
}
</style>
```

Использование `vue-loader` предоставляет множество интересных возможностей:

- Позволяет использовать разнообразные загрузчики webpack для разных секций компонента Vue, например Sass для `<style>` и Pug для `<template>`;
- Позволяет использовать пользовательские секции в файлах `.vue`, обрабатывая их указанными цепочками загрузчиков;
- Обращается со статическими ресурсами, указанными в `<style>` и `<template>` как с зависимостями модуля и обрабатывает их с помощью загрузчиков webpack;
- Может эмулировать локальный (scoped) CSS для каждого компонента;
- Горячая перезагрузка модулей с сохранением состояния на этапе разработки.

В двух словах, сочетание webpack и `vue-loader` предоставляет вам современный, гибкий и невероятно эффективный подход к написанию клиентских приложений на Vue.js.
