---
title: Однофайловые компоненты Vue
sidebar: auto
---

# Однофайловые компоненты Vue

## Введение

Файл `*.vue` это собственный формат Vue, использующий HTML-подобный синтаксис для описания компонента. Каждый `*.vue` файл состоит из трёх главных секций: `<template>`, `<script>` и `<style>`, а также опциональных пользовательских блоков:

``` vue
<template>
  <div class="example">{{ msg }}</div>
</template>

<script>
export default {
  data () {
    return {
      msg: 'Hello world!'
    }
  }
}
</script>

<style>
.example {
  color: red;
}
</style>

<custom1>
  Это может быть, например, документация для компонента
</custom1>
```

`vue-loader` парсит файл, извлекает каждую из секций, обрабатывает их при необходимости другими загрузчиками webpack, и в итоге собирает всё обратно в ES-модуль где экспорт по умолчанию будет объектом настроек компонента Vue.js.

`vue-loader` предоставляет возможность использовать нестандартные языки, например пре-процессоры CSS и языки шаблонов компилируемые в HTML, указывая атрибут `lang` для секции файла. Например, вы можете использовать SASS для стилей вашего компонента:

``` vue
<style lang="sass">
  /* используем SASS! */
</style>
```

Подробнее на странице [использования пре-процессоров](./guide/pre-processors.md).

## Секции файла

### Шаблон (template)

- Каждый `*.vue` файл может содержать максимум один блок `<template>`.

- Содержимое извлекается, передаётся в `vue-template-compiler`, где предварительно будет скомпилировано в JavaScript render-функции, и наконец внедряется в описываемый компонент в секции `<script>`.

### Логика (script)

- Каждый `*.vue` файл может содержать максимум один блок `<script>`.

- Секция исполняется как ES-модуль.

- **Экспорт по умолчанию** должен быть [объектом опций компонента](https://ru.vuejs.org/v2/api/index.html#Опции-—-данные) Vue.js. Экспортирование расширенного конструктора, созданного с помощью `Vue.extend()` также поддерживается, но обычный объект предпочтителен.

- Любые правила webpack, которые совпадут с форматом `.js` файлов (или расширения, указанного в атрибуте `lang`) также будут применены к содержимому блока `<script>`.

### Стили (style)

- По умолчанию считается: `/\.css$/`.

- Может быть несколько тегов `<style>` в одном `*.vue` файле.

- Тег `<style>` может иметь атрибуты `scoped` или `module` (подробнее — [Локальный (scoped) CSS](./guide/scoped-css.md) и [CSS модули](./guide/css-modules.md)) для возможности инкапсулировать стили в текущий компонент. Несколько тегов `<style>` с разными режимами инкапсуляции могут быть использованы в одном компоненте.

- Любые правила webpack, которые совпадут с форматом `.css` файлов (или расширения, указанного в атрибуте `lang`) также будут применены к содержимому блока `<style>`.

### Пользовательские блоки

Дополнительные пользовательские блоки могут быть добавлены в `*.vue` файл для любых потребностей проекта, например блок `<docs>`. `vue-loader` будет использовать имя тега для определения какими загрузчиками webpack требуется обрабатывать содержимое этой секции. Загрузчики webpack должны быть указаны в секции `loaders` настроек `vue-loader`.

Подробнее в разделе [пользовательских блоков](./guide/custom-blocks.md).

### Импорты из других файлов

Если вы предпочитаете разделять `*.vue` компоненты на несколько файлов, вы можете использовать атрибут `src` для импорта содержимого другого файла в секцию, например:

``` vue
<template src="./template.html"></template>
<style src="./style.css"></style>
<script src="./script.js"></script>
```

Обратите внимание, что импорты через `src` следуют тем же правилам webpack по разрешению путей к модулям, что означает:

- Относительные пути должны начинаться с `./`
- Вы можете импортировать ресурсы из npm-зависимостей:

``` vue
<!-- импорт файла из установленного npm-пакета "todomvc-app-css" -->
<style src="todomvc-app-css/index.css">
```

`src` импорты также работают с пользовательскими блоками, например:

``` vue
<unit-test src="./unit-test.js">
</unit-test>
```

## Подсветка синтаксиса / поддержка IDE

На данный момент есть поддержка подсветки синтаксиса для следующих IDE/редакторов:

- [Sublime Text](https://github.com/vuejs/vue-syntax-highlight)
- [VS Code](https://marketplace.visualstudio.com/items?itemName=octref.vetur)
- [Atom](https://atom.io/packages/language-vue)
- [Vim](https://github.com/posva/vim-vue)
- [Emacs](https://github.com/AdamNiederer/vue-mode)
- [Brackets](https://github.com/pandao/brackets-vue)
- [JetBrains IDE](https://plugins.jetbrains.com/plugin/8057) (WebStorm, PhpStorm, и т.п.)

Будем рады видеть разработки и для других редакторов и IDE! Если вы не используете никаких пре-процессоров в компонентах Vue, вы также можете использовать синтаксис HTML в вашем редакторе для `*.vue` файлов.

## Комментарии

Внутри каждой секции вы можете использовать синтаксис комментариев, который соответствует используемому языку (HTML, CSS, JavaScript, Pug, и т.д.). Для комментариев на уровне секций, используйте синтаксис комментариев HTML: `<!-- ваш комментарий -->`
