package com.hdp.pi.api.kolon;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.hdp.pi.common.MediaType;
import com.hdp.pi.domain.baseservice.GlobalVariable;
import com.hdp.pi.dto.DTO;
import com.hdp.pi.security.controller.JWTSecurityController;
import com.hdp.pi.service.baseservice.GlobalVariableService;
import com.hdp.pi.service.kolon.KolonMemberService;


@Controller
@RequestMapping("/v1.0/internal/admin/kolon")
public class KolonMemberController extends JWTSecurityController{
	
	SimpleDateFormat formatter = new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss");
	
	DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@Autowired
	private KolonMemberService kolonMemberService;
	
	@Autowired
	private GlobalVariableService globalVariableService;
	
	@Value("${kolon.property.businessCode}")
	private String businessCode;
	
	@Value("${kolon.property.variableTypeName}")
	private String variableTypeName;
	
	@Value("${kolon.property.variableCode}")
	private String variableCode;

	/**
	 * 同步数据到本地数据库
	 * @param req
	 * @return
	 */
	@RequestMapping(value = "/syncData", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8)
	public @ResponseBody String syncData(HttpServletRequest req) {
		DTO dto = DTO.newDTO();
		try {
			kolonMemberService.syncMemberData();
			kolonMemberService.syncProductData();
			kolonMemberService.syncSaleData();
			return dto.toJson();
		} catch (Exception e) {
			e.printStackTrace();
			dto.errMsg = "error";
			dto.errCode = -1;
			return dto.toJson();
		}
	}
	
	/**
	 * 把本地数据发送到FTP服务器
	 * @param req
	 * @return
	 */
	@RequestMapping(value = "/sendData", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8)
	public @ResponseBody String sendData(HttpServletRequest req,
			@RequestParam(value = "time",required = false) String time) {
		DTO dto = DTO.newDTO();
		try {
			String lastSendTime = null;
			if(time != null){
				lastSendTime = time;
			}else{
				lastSendTime = globalVariableService.findVariableValue(businessCode, variableTypeName, variableCode);
				if(lastSendTime == null){
					lastSendTime = dateFormat.format(new Date());
				}
			}
			Date newLastSendTime = kolonMemberService.sendData(formatter.parse(lastSendTime));
			//更新时间
			GlobalVariable globalVariable = globalVariableService.findVariable(businessCode, variableTypeName, variableCode);
			globalVariable.strVariableValue = dateFormat.format(newLastSendTime);
			globalVariableService.templateUpdate(globalVariable);
			return dto.toJson();
		} catch (Exception e) {
			e.printStackTrace();
			dto.errMsg = "error";
			dto.errCode = -1;
			return dto.toJson();
		}
	}
	
	/**
	 * 同步数据并把本地数据发送到FTP服务器
	 * @param req
	 * @return
	 */
	@RequestMapping(value = "/syncAndSendData", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8)
	public @ResponseBody String syncAndSendData(HttpServletRequest req,
			@RequestParam(value = "time",required = false) String time) {
		DTO dto = DTO.newDTO();
		try {
			kolonMemberService.syncMemberData();
			kolonMemberService.syncProductData();
			kolonMemberService.syncSaleData();
			
			String lastSendTime = null;
			if(time != null){
				lastSendTime = time;
			}else{
				lastSendTime = globalVariableService.findVariableValue(businessCode, variableTypeName, variableCode);
				if(lastSendTime == null){
					lastSendTime = dateFormat.format(new Date());
				}
			}
			Date newLastSendTime = kolonMemberService.sendData(formatter.parse(lastSendTime));
			//更新时间
			GlobalVariable globalVariable = globalVariableService.findVariable(businessCode, variableTypeName, variableCode);
			globalVariable.strVariableValue = dateFormat.format(newLastSendTime);
			globalVariableService.templateUpdate(globalVariable);
			return dto.toJson();
		} catch (Exception e) {
			e.printStackTrace();
			dto.errMsg = "error";
			dto.errCode = -1;
			return dto.toJson();
		}
	}
	
	

}
