package com.hdp.pi.domain.kolon;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * kolon会员表
 */
@Entity
@Table(name = "pi_kolon_member")
public class KolonMember implements Serializable {

	private static final long serialVersionUID = -1993113660012534693L;

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	public Long id;

	@Column(name = "cs_no", nullable = false)
	public String csNo;

	@Column(name = "card_no", nullable = true)
	public String cardNo;
	
	@Column(name = "phone", nullable = true)
	public String phone;

	@Column(name = "last_name", nullable = true)
	public String lastName;

	@Column(name = "first_name", nullable = true)
	public String firstName;

	@Column(name = "email", nullable = true)
	public String email;

	@Column(name = "wechat_last_name", nullable = true)
	public String wechatLastName;

	@Column(name = "wechat_first_name", nullable = true)
	public String wechatFirstName;

	/**
	 * 1.钻石会员  2.白金会员  3. 金卡会员  4.银卡会员  5. 绿卡会员
	 */
	@Column(name = "status", nullable = true)
	public Integer status;

	@Column(name = "bonus", nullable = true)
	public Integer bonus;

	/**
	 * 1.First time buyer  2.Active  3. Defecting  4.Inactive
	 */
	@Column(name = "lifecycle", nullable = true)
	public String lifecycle;

	/**
	 * 1.现存顾客  2.潜在顾客  
	 */
	@Column(name = "customer_type", nullable = true)
	public Integer customerType;

	/**
	 * pi_member ID
	 */
	@Column(name = "mid", nullable = true)
	public Long mid;

	/**
	 * 1 来源PI+, 2 来源Emarsys
	 */
	@Column(name = "data_source", nullable = true)
	public Integer dataSource;
	
	/**
	 * 创建时间
	 */
	@Column(name = "join_time", nullable = true)
	public Date joinTime;

	/**
	 * 更新时间
	 */
	@Column(name = "update_time", nullable = true)
	public Date updateTime;

}
