/**
 * 
 */
package com.hdp.pi.repository.kolon;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import com.hdp.pi.domain.kolon.KolonMember;

/**
 * @author yangyw
 *
 */
@Repository
public interface KolonMemberRepository extends JpaRepository<KolonMember, Long>, JpaSpecificationExecutor<KolonMember> {

	KolonMember findFirstByCsNo(String csNo);
	
	KolonMember findFirstByPhone(String phone);
	
	List<KolonMember> findByUpdateTimeGreaterThan(Date updateTime);
	
	/**
	 * 查找更新的
	 * @param dataSource
	 * @param updateTime
	 * @return
	 */
	List<KolonMember> findByDataSourceAndUpdateTimeGreaterThan(Integer dataSource, Date updateTime);
	
	/**
	 * 查找新注册的
	 * @param dataSource
	 * @param joinTime
	 * @return
	 */
	List<KolonMember> findByDataSourceAndJoinTimeGreaterThan(Integer dataSource, Date joinTime);
	
	/**
	 * 查找
	 * @param joinTime
	 * @param updateTime
	 * @return
	 */
	List<KolonMember> findByJoinTimeGreaterThanOrUpdateTimeGreaterThan(Date joinTime, Date updateTime);
}
