package com.hdp.pi.service.kolon;

import java.util.Date;
import java.util.List;

import com.hdp.pi.domain.kolon.KolonMember;


public interface KolonMemberService {

	KolonMember findOneByCsNo(String csNo);
	
	void save(KolonMember kolonMember);
	
	/**
	 * 查找新注册的
	 * @return
	 */
	List<KolonMember> findByDataSourceAndUpdateTimeGreaterThan(Integer dataSource, Date updateTime);
	
	/**
	 * 查找更新时间在updateTime之后的数据
	 * @param updateTime
	 * @return
	 */
	List<KolonMember> findByUpdateTimeGreaterThan(Date updateTime);
	
	/**
	 * 对比数据
	 * @param s
	 */
	void matchData(String[] s);
	
	/**
	 * 同步会员数据
	 */
	void syncMemberData();
	
	void syncProductData();
	
	void syncSaleData();
	
	/**
	 * 生成文件并发送到FTP服务器,返回最后更新的时间
	 * @param time
	 * @return
	 */
	Date sendData(Date time);
	
}
