/**
 * 
 */
package com.hdp.pi.service.kolon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import au.com.bytecode.opencsv.CSVWriter;

import com.hdp.pi.domain.kolon.KolonMember;
import com.hdp.pi.domain.kolon.Product;
import com.hdp.pi.domain.kolon.Sale;
import com.hdp.pi.dto.kolon.KolonMemberDTO;
import com.hdp.pi.repository.kolon.KolonMemberPreassignSnRepository;
import com.hdp.pi.repository.kolon.KolonMemberRepository;
import com.hdp.pi.repository.kolon.ProductRepository;
import com.hdp.pi.repository.kolon.SaleRepository;
import com.hdp.pi.utils.kolon.FtpUtil;
import com.hdp.pi.utils.kolon.Util;

/**
 * @author yangyw
 *
 */
public class KolonMemberServiceImpl implements KolonMemberService {
	
	@Autowired
	private FtpUtil ftpUtil;

	@Value("${kolon.property.ftp.getFileName}")
	private String memberFileName;
	
	@Value("${kolon.property.ftp.saleFileName}")
	private String saleFileName;
	
	@Value("${kolon.property.ftp.productFileName}")
	private String productFileName;
	
	@Autowired
	private KolonMemberRepository kolonMemberRepository;

	@Autowired
	private KolonMemberPreassignSnRepository kolonMemberPreassignSnRepository;
	
	@Autowired
	private ProductRepository productRepository;
	
	@Autowired
	private SaleRepository saleRepository;
	
	@Override
	public KolonMember findOneByCsNo(String csNo) {
		return kolonMemberRepository.findFirstByCsNo(csNo);
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void save(KolonMember kolonMember) {
		kolonMemberRepository.save(kolonMember);
	}

	@Override
	public List<KolonMember> findByUpdateTimeGreaterThan(Date updateTime) {
		return kolonMemberRepository.findByUpdateTimeGreaterThan(updateTime);
	}

	@Override
	public List<KolonMember> findByDataSourceAndUpdateTimeGreaterThan(
			Integer dataSource, Date updateTime) {
		return kolonMemberRepository.findByDataSourceAndUpdateTimeGreaterThan(
				dataSource, updateTime);
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void matchData(String[] s) {
		KolonMemberDTO kolonMemberDTO = new KolonMemberDTO(s);
		String csNo = kolonMemberDTO.csNo;
		KolonMember kolonMember = null;
		if(StringUtils.isNotEmpty(kolonMemberDTO.phone)){
			kolonMember = kolonMemberRepository.findFirstByPhone(kolonMemberDTO.phone);
		}
		if(kolonMember == null){
			kolonMember = this.findOneByCsNo(csNo);
		}
		if (kolonMember == null) { // 插入数据
			kolonMember = new KolonMember();
			kolonMember.csNo = csNo;
			kolonMember.cardNo = kolonMemberDTO.cardNo;
			kolonMember.phone = kolonMemberDTO.phone;
			kolonMember.lastName = kolonMemberDTO.lastName;
			kolonMember.firstName = kolonMemberDTO.firstName;
			kolonMember.email = kolonMemberDTO.email;
			kolonMember.status = kolonMemberDTO.status;
			kolonMember.bonus = kolonMemberDTO.bonus;
			kolonMember.lifecycle = kolonMemberDTO.lifecycle;
			kolonMember.customerType = kolonMemberDTO.customerType;
			kolonMember.dataSource = 2;
			Date date = new Date();
			kolonMember.joinTime = date;
			kolonMember.updateTime = date;
			this.save(kolonMember);
		} else { // 更新
			boolean flag = false;
			String oldCsNo = null;//是否更新了csno
			if(!kolonMemberDTO.csNo.equals(kolonMember.csNo)){//kolon和派加都注册了，以kolon为准
				oldCsNo = kolonMember.csNo;
				kolonMember.csNo = kolonMemberDTO.csNo;
				flag = true;
				
			}
			if(!kolonMemberDTO.cardNo.equals(kolonMember.cardNo)){//kolon和派加都注册了，以kolon为准
				kolonMember.cardNo = kolonMemberDTO.cardNo;
				flag = true;
			}
			
			if (!Util.isNotNull(kolonMember.email)
					|| !kolonMember.email.endsWith(kolonMemberDTO.email)) {
				kolonMember.email = kolonMemberDTO.email;
				flag = true;
			}
			if (!Util.isNotNull(kolonMember.firstName)
					|| !kolonMember.firstName
							.endsWith(kolonMemberDTO.firstName)) {
				kolonMember.firstName = kolonMemberDTO.firstName;
				flag = true;
			}
			if (!Util.isNotNull(kolonMember.lastName)
					|| !kolonMember.lastName
							.endsWith(kolonMemberDTO.lastName)) {
				kolonMember.lastName = kolonMemberDTO.lastName;
				flag = true;
			}
			if (flag) {
				kolonMember.updateTime = new Date();
				this.save(kolonMember);
				if(oldCsNo!=null){//csno被kolon覆盖
					kolonMemberPreassignSnRepository.setStatusWithKolonReplace(oldCsNo);
				}
			}
		}
	}

	@Override
	public void syncMemberData() {
		List<String[]> list = ftpUtil.readCSVFile(memberFileName);
		if (list != null) {
			boolean firstRow = true;
			for (String[] row : list) {
				if (firstRow) {
					firstRow = false;
				} else {
					this.matchData(row);
				}
			}
		}
		ftpUtil.moveFile(memberFileName);
	}

	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	private void saveProductAbsentIf(Product product){
		if(product == null || product.id == null){
			return;
		}
		Product p = productRepository.findOne(product.id);
		if(p == null){
			productRepository.save(product);
		}
	}
	
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	private void saveSale(Sale sale){
		if(sale == null){
			return;
		}
		if(sale.oId == null){
			return;
		}
		if(sale.oDate == null){
			return;
		}
		if(sale.customer == null){
			return;
		}
		if(sale.item == null){
			return;
		}
		if(sale.quantity == null){
			return;
		}
		if(sale.amount == null){
			return;
		}
		saleRepository.save(sale);
	}
	
	private Product newProduct(String[] row){
		Product p = new Product();
		try{
			p.id = Util.getByIndex(row, 0);
			p.title = Util.getByIndex(row, 1);
			p.category = Util.getByIndex(row, 2);
			p.image = Util.getByIndex(row, 3);
			p.link = Util.getByIndex(row, 4);
			p.avaliable = Util.getByIndex(row, 5);
			p.dept = Util.getByIndex(row, 6);
			p.seaons = Util.getByIndex(row, 7);
			p.planyy = Util.getByIndex(row, 8);
			p.color = Util.getByIndex(row, 9);
			p.price = Util.getByIndex(row, 10);
		}catch(Throwable e){
			e.printStackTrace();
		}
		return p;
	}
	
	private Sale newSale(String[] row){
		Sale s = new Sale();
		try{
			s.oId = Util.getByIndex(row, 0);
			s.oDate = Integer.valueOf(Util.getByIndex(row, 1));
			s.customer = Util.getByIndex(row, 2);
			s.item = Util.getByIndex(row, 3);
			s.quantity = Integer.valueOf(Util.getByIndex(row, 4));
			s.amount = Double.valueOf(Util.getByIndex(row, 5));
		}catch(Throwable e){
			e.printStackTrace();
		}
		return s;
	}
	
	@Override
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void syncProductData() {
		List<String[]> list = ftpUtil.readCSVFile(productFileName);
		if (list != null) {
			boolean firstRow = true;
			for (String[] row : list) {
				if (firstRow) {
					firstRow = false;
				} else {
					saveProductAbsentIf(newProduct(row));
				}
			}
		}
		ftpUtil.moveFile(productFileName);
	}
	
	@Override
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void syncSaleData() {
		List<String[]> list = ftpUtil.readCSVFile(saleFileName);
		if (list != null) {
			boolean firstRow = true;
			for (String[] row : list) {
				if (firstRow) {
					firstRow = false;
				} else {
					saveSale(newSale(row));
				}
			}
		}
		ftpUtil.moveFile(saleFileName);
	}
	
	@Override
	public Date sendData(Date time) {
		Date lastSendDate = time;
		
		//获取记录
		List<KolonMember> kolonMembers = kolonMemberRepository.findByJoinTimeGreaterThanOrUpdateTimeGreaterThan(time, time);
		
		List<String[]> addData = getDataList();
		List<String[]> updateData = getDataList();
		
		for(KolonMember km : kolonMembers){
			if(km.dataSource == 2){
				updateData.add(new String[] { km.csNo.toString(), km.phone, km.email, km.wechatFirstName, km.wechatLastName});
			}else if(km.dataSource == 1 && km.joinTime.before(km.updateTime)){  //加入时间在更新时间之前，数据是更新的
				updateData.add(new String[] { km.csNo.toString(), km.phone, km.email, km.wechatFirstName, km.wechatLastName});
			}else{
				addData.add(new String[] { km.csNo.toString(), km.phone, km.email, km.wechatFirstName, km.wechatLastName});
			}
			if(lastSendDate.before(km.updateTime)){  //获取数据较后的更新时间
				lastSendDate = km.updateTime;
			}
		}
		
		CSVWriter addWriter = ftpUtil.getCSVWriter(1);
		writeDataToFile(addWriter, addData);
		CSVWriter updateWriter = ftpUtil.getCSVWriter(2);
		writeDataToFile(updateWriter, updateData);
		
		//上传文件
		uploadFile();
		return lastSendDate;
	}

	private List<String[]> getDataList() {
		List<String[]> addData = new ArrayList<String[]>();
		String[] header = "CS_NO,Phone,Email,Wechat Last Name,Wechat First Name".split(",");
		addData.add(header);
		return addData;
	}
	
	public void writeDataToFile(CSVWriter writer, List<String[]> data){
		try {
			writer.writeAll(data);
			writer.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void uploadFile(){
		ftpUtil.uploadFile();
	}

}
