package com.hdp.pi.starter.kolon;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.orm.jpa.EntityScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ComponentScan(basePackages = {"com.hdp.pi.utils.kolon","com.hdp.pi.api.kolon"  })
@EnableAutoConfiguration
@PropertySource({ "classpath:kolon.${mode}.properties","classpath:kolon.properties" })
@EnableJpaRepositories(value = "com.hdp.pi.repository")
@EntityScan("com.hdp.pi.domain")
@ImportResource({ "classpath*:META-INF/spring/applicationContext.xml" })
@EnableScheduling
public class KolonStarter implements CommandLineRunner {
	 private static final Logger LOGGER = LoggerFactory.getLogger(KolonStarter.class);
	
	 public static void main(String[] args) {
		 SpringApplication app = new SpringApplication(KolonStarter.class);
		 app.setWebEnvironment(true);
		 app.run(args);
	 }
	
	 @Override
	 public void run(String... args) throws Exception {
		 LOGGER.info("piplus-parent kolon服务已启动！");
		 Thread.currentThread().join();
	 }

	
}
