package com.hdp.pi.utils.kolon;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.hdp.pi.domain.baseservice.GlobalVariable;
import com.hdp.pi.service.baseservice.GlobalVariableService;
import com.hdp.pi.service.kolon.KolonMemberService;

@Component
public class FtpScheduledTask {

	SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@Autowired
	private KolonMemberService kolonMemberService;

	@Autowired
	private GlobalVariableService globalVariableService;

	@Value("${kolon.property.businessCode}")
	private String businessCode;

	@Value("${kolon.property.variableTypeName}")
	private String variableTypeName;

	@Value("${kolon.property.variableCode}")
	private String variableCode;

	@Autowired
	private FtpUtil ftpUtil;

	// 每天上午10:30触发
	@Scheduled(cron = "0 30 10 * * ?")
	public void scheduledReadTask() {
		readCSVFile();
	}

	// 每天凌晨1:00触发
	@Scheduled(cron = "0 00 1 * * ?")
	public void scheduledWriteTask() {
		writeCSVFile();
	}

	/**
	 * 同步数据
	 */
	public void readCSVFile() {
		kolonMemberService.syncMemberData();
		kolonMemberService.syncProductData();
		kolonMemberService.syncSaleData();
	}

	/**
	 * 发送数据
	 */
	public void writeCSVFile() {
		try {
			String lastSendTime = globalVariableService.findVariableValue(
					businessCode, variableTypeName, variableCode);
			if (lastSendTime == null) {
				lastSendTime = dateFormat.format(new Date());
			}
			Date newLastSendTime;

			newLastSendTime = kolonMemberService.sendData(formatter
					.parse(lastSendTime));

			// 更新时间
			GlobalVariable globalVariable = globalVariableService.findVariable(
					businessCode, variableTypeName, variableCode);
			globalVariable.strVariableValue = dateFormat
					.format(newLastSendTime);
			globalVariableService.templateUpdate(globalVariable);
		} catch (ParseException e) {
			e.printStackTrace();
		}
	}

}
