'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');

var ForumComplaintService=require('../../service/forumComplaintService');
var ForumUserService = require("../../service/forumUserService");
module.exports = function(app) {
	app.use('/admin/forum', router);
};

//获取举报分页列表
router.get('/complaints/getComplaints', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var conditions={
    	ent_code:req.session.user.ent_code
    };
    var type=req.query.type;
    var begin = req.query.begin;
    var end = req.query.end;
    if(type){
    	conditions.type = type;
    }
    if(begin || end){
    	conditions.created = {};
    	if(begin){
    		conditions.created['$gte'] = new Date(begin);
    	}
    	if(end){
    		var t = new Date(end);
    		t.setDate(t.getDate() + 1);
    		conditions.created['$lte'] = t;
    	}
    }
	ForumComplaintService.getForumComplaintPageList(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});

//在获取举报详细
router.get('/complaints/:complaintid/detail', function(req, res, next) {
	var complaintid = req.params.complaintid;
	ForumComplaintService.getDetailByComplaintid(complaintid,function(err,result){
		if(err){
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign({result:result}, returnCode.SUCCESS));
		}
	});
});

//删除黑名单根据id
router.get('/complaints/:id/del', function(req, res, next) {
	var id = req.params.id;
	ForumComplaintService.removeComplaintById(id,function(err,result){
		if(err){
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(result, returnCode.SUCCESS));
		}
	});
});

//在举报里屏蔽用户
router.post('/complaints/blacklist', function(req, res, next) {
	var id = req.body.id;
	ForumUserService.updateUserById(id,{status:2},function(err,result){
		if(err){
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(result, returnCode.SUCCESS));
		}
	});
});