'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');
var mongoose = require('mongoose');
var ForumThread = mongoose.model('ForumThread');
var forumThreadService = require('../../service/forumThreadService');
var forumRolePermissionService = require('../../service/forumRolePermissionService');
var forumPraiseLogService = require('../../service/forumPraiseLogService');
var forumShareLogService = require('../../service/forumShareLogService');
var forumCommentService = require('../../service/forumCommentService');
var forumTagService = require('../../service/forumTagService');
var forumUserService = require('../../service/forumUserService');

var httpService = require('../../service/httpService');

var userUtil = require('../../utils/user');
var async = require('async');
var _ = require('lodash');

module.exports = function(app) {
    app.use('/admin/forum', router);
};


//---------------------文章表单操作---------------------------------

//获取用户列表
router.post('/member/searchMembers', function(req, res, next) {
    var pageNo = req.body.pageNo,
        pageSize = req.body.pageSize,
        ent_code = req.session.user.ent_code,
        search = req.body.search;
    if (pageNo && pageSize) {
        var q = {
            ent_code: ent_code
        };
        if (search.nickName) {

            q.nickName = {
                $regex: search.nickName
            };
        }
        if (search.displayName) {
            q.displayName = {
                $regex: search.displayName
            };
        }
        if (search.sex !== 3) {
            q.sex = search.sex;
        }
        if (search.status) {
            q.status = search.status;
        }
        forumUserService.searchMembersAndLimitActions(pageNo, pageSize, q, function(err, results) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(results);
            }
        });
    } else {
        console.error('params error');
        res.json({
            result: false,
            err: 'params error'
        });
    }
});

//获取单用户
router.get('/member/:mid/get', function(req, res, next) {
    var mid = req.params.mid || null;
    if (mid) {
        forumUserService.getUserById(mid, function(err, user) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                var obj = {
                    result : true,
                    data : user
                }
                res.json(obj);
            }
        });
    } else {
        console.error('params error');
        res.json({
            result: false,
            err: 'params error'
        });
    }
});
