'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash'),
    then = require('thenjs');
var mongoose = require('mongoose');
var ForumThread = mongoose.model('ForumThread'),
    ForumPVLog = mongoose.model('ForumPVLog');
var forumThreadService = require('../../service/forumThreadService');
var forumRolePermissionService = require('../../service/forumRolePermissionService');
var forumPraiseLogService = require('../../service/forumPraiseLogService');
var forumShareLogService = require('../../service/forumShareLogService');
var forumCommentService = require('../../service/forumCommentService');
var forumTagService = require('../../service/forumTagService');
var forumUserService = require('../../service/forumUserService');
// var forumLimitActionRefService = require('../../service/forumLimitActionRefService');
var forumLimitOperationService = require('../../service/forumLimitOperationService');

var httpService = require('../../service/httpService');

var userUtil = require('../../utils/user');
var async = require('async');

module.exports = function(app) {
    app.use('/admin/forum', router);
};


//---------------------文章表单操作---------------------------------
var getClientIP = function(req) {
    var ipAddress;
    var headers = req.headers;
    var forwardedIpsStr = headers['x-real-ip'] || headers['x-forwarded-for'];
    if (forwardedIpsStr) {
        ipAddress = forwardedIpsStr;
    } else {
        ipAddress = null;
    }
    if (!ipAddress) {
        ipAddress = req.connection.remoteAddress;
    }
    return ipAddress;
};

//新增论坛文章
router.post('/thread/create', function(req, res, next) {
    var rs = {},
        ent_code = req.session.user.ent_code,
        icon = req.session.user.headPic,
        nickName = req.session.user.name;
    req.body.ent_code = ent_code;
    if (!req.body.share) {
        delete req.body.share;
    }
    var uid = req.session.user.id;
    // var uid='12345';
    if (req.body.pid) {
        req.body.level = 2;
    }
    async.waterfall([
        function(callback) {
            forumUserService.getUserByUid(uid, callback);
        }
    ], function(err, user) {
        if (err) {
            res.json(returnCode.BUSY);
        } else {
            if (user) {
                //更新后台对应用户信息
                var isUpdate = false,
                    updateObj = {};
                if(icon){
                    if(!user.icon || user.icon != icon){
                        isUpdate = true;
                        updateObj.icon = icon;
                    }    
                }    
                if(nickName){
                    if(!nickName || !user.nickName || user.nickName !=nickName){
                        isUpdate =true;
                        updateObj.nickName = nickName;
                    }    
                }
                if(isUpdate){
                    user.update(updateObj,function(err,data){
                        if(err)console.log(err);
                    });    
                }
                //创建帖子
                req.body.from = user._id;
                forumThreadService.createThread(req.body, function(err, entity) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        rs.data = {
                            'id': entity._id
                        };
                        res.json(_.assign(rs, returnCode.SUCCESS));
                    }
                });
            } else {
                //创建后台对应用户
                var entity = {
                    uid: uid,
                    ent_code:ent_code,
                    nickName: nickName,
                    icon: icon
                };
                forumUserService.createUser(entity, function(err, doc) {
                    if (err) {
                        res.json(returnCode.BUSY);
                    } else {
                        //创建帖子
                        req.body.from = doc._id;
                        forumThreadService.createThread(req.body, function(err, entity) {
                            if (err) {
                                console.error(err);
                                res.json(returnCode.BUSY);
                            } else {
                                rs.data = {
                                    'id': entity._id
                                };
                                res.json(_.assign(rs, returnCode.SUCCESS));
                            }
                        });
                    }
                });
            }
        }
    });
});

//获取目标论坛文章
router.get('/thread/:tid/get', function(req, res, next) {
    var uid = req.session.user.id;
    var tid = req.params.tid || null;
    var rs = {};
    if (tid) {
        async.waterfall([
            function(callback) {
                forumThreadService.getThreadById(tid, function(err, thread) {
                    if (err) {
                        callback(err, null);
                    } else {
                        callback(null, thread);
                    }
                });
            },
            function(thread,callback) {
                if(thread && thread.info && thread.info._id){
                    forumTagService.getAllTag({ent_code:req.session.user.ent_code,info:thread.info._id}, 1, 100, function(err, results) {
                        if (err) {
                            callback(err, null);
                        } else {
                            callback(null, [thread,results]);
                        }
                    });
                }else{
                    callback(null,[thread]);
                }
                
            },
             function(datas,callback) {
                forumUserService.getUserByUid(uid,function(err, results) {
                    if (err) {
                        callback(err, null);
                    } else {
                        datas.push(results)
                        callback(null, datas);
                    }
                });
            }
        ], function(err, results) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                var isSameAuthor = false;
                if(results[0].from && results[0].from.uid){
                    if(!isNaN(results[0].from.uid)){
                        isSameAuthor = true;
                    }
                }

                if (results[0].pid) {
                    forumThreadService.getById(results[0].pid, function(err, parentThread) {
                        rs.data = results[0];
                        rs.tagList = results[1];
                        rs.parentThread = parentThread;
                        rs.isSameAuthor = isSameAuthor;
                        res.json(_.assign(rs, returnCode.SUCCESS));
                    });
                } else {
                    rs.data = results[0];
                    rs.tagList = results[1];
                    rs.isSameAuthor = isSameAuthor;
                    res.json(_.assign(rs, returnCode.SUCCESS));
                }

            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//更新文章状态、如：屏蔽
router.post('/thread/:tid/update', function(req, res, next) {
    var tid = req.params.tid;
    var fatherTitle = req.body.father;
    delete req.body.father;
    req.body.ent_code = req.session.user.ent_code;
    if (tid) {
        forumThreadService.updateThreadById(tid, req.body, function(err, thread) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json({
                    message: "success",
                    data: thread,
                    title: fatherTitle
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//删除文章
router.post('/thread/:tid/delete', function(req, res, next) {
    var tid = req.params.tid;
    if (tid) {
        forumThreadService.deleteThreadById(tid, function(err, thread) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//文章置顶
router.post('/thread/:tid/:fid/top', function(req, res, next) {
    var tid = req.params.tid; //文章ID
    var fid = req.params.fid; //板块ID
    if (tid && fid) {
        forumThreadService.updateTopByThreadId(fid, tid, function(err, thread) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//文章取消置顶
router.post('/thread/:tid/:fid/unTop', function(req, res, next) {
    var tid = req.params.tid; //文章ID
    var fid = req.params.fid; //板块ID
    if (tid && fid) {
        forumThreadService.updateUnTopByThreadId(fid, tid, function(err, thread) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//文章推荐
router.post('/thread/:tid/:fid/recommend', function(req, res, next) {
    var tid = req.params.tid,
        fid = req.params.fid,
        ent_code = req.session.user.ent_code,
        mid = req.body.mid;//板块ID
    if (tid && fid) {
        forumThreadService.updateRecommendByThreadId(tid, function(err, thread) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if(mid){
                    forumLimitOperationService.checkLimitOperationProhibitionAddIntegral(tid, function(err, flag){
                        if(err){
                            console.error(err);
                            res.json(returnCode.PROHIBITION_OF_SPEECH);
                        }else{
                            if(flag){
                                res.json(returnCode.PROHIBITION_OF_SPEECH);
                            }else{
                                httpService.sendRequest(ent_code,mid,'thread_recomment');
                                res.json(returnCode.SUCCESS);
                            }
                        }
                    });
                }else{
                    res.json(returnCode.SUCCESS);    
                }
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//文章取消推荐
router.post('/thread/:tid/:fid/unRecommend', function(req, res, next) {
    var tid = req.params.tid; //文章ID
    var fid = req.params.fid; //板块ID
    if (tid && fid) {
        forumThreadService.updateUnRecommendByThreadId(tid, function(err, thread) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//文章列表
router.get('/threads/list', function(req, res, next) {
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var infoId = req.query.infoId;
    var tagId = req.query.tagId;
    var pid = req.query.pid;
    var content = req.query.content;
    var type = req.query.type;
    var status = req.query.status;
    var nickName = req.query.nickName;

    var conditions = {
        ent_code: req.session.user.ent_code,
        level: 1,
        status:{$ne:3}
    };
    if (infoId) {
        conditions.info = infoId;
    }
    if (tagId) {
        conditions.tag = {
            $in: [tagId]
        };
    }

    if (pid) {
        conditions.pid = pid;
        conditions.level = 2;
    }

    if (content) {
        conditions.content = {
            $regex: content,
            $options: 'i'
        }
    }
    if(type){
        conditions.type = type;
    }

    if(status){
        conditions.status = status;
    }

    if(nickName){
        forumThreadService.getAllThreadByFidAndNickName(nickName, conditions, pageNo, pageSize, null, function(err, results) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {

                if (pid) {
                    forumThreadService.getById(pid, function(err, parentThread) {
                        res.json(_.assign({
                            parentThread: parentThread
                        }, results, returnCode.SUCCESS));
                    });
                } else {
                    res.json(_.assign(results, returnCode.SUCCESS));
                }
            }
        });
    }else{
        forumThreadService.getAllThreadByFid(conditions, pageNo, pageSize, null, function(err, results) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {

                if (pid) {
                    forumThreadService.getById(pid, function(err, parentThread) {
                        res.json(_.assign({
                            parentThread: parentThread
                        }, results, returnCode.SUCCESS));
                    });
                } else {
                    res.json(_.assign(results, returnCode.SUCCESS));
                }
            }
        });
    }

    
});


//评论列表
router.get('/thread/:tid/comment/list', function(req, res, next) {

    var tid = req.params.tid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var content = req.query.content || '';
    var conditions = {
        ent_code: req.session.user.ent_code,
        thread: tid,
        // level: '1',
        // status: {
        //     $ne: 2
        // } //过滤被删除的数据，status 为 2 表示删除
    };
    if(content){
        conditions.content =  { $regex:content, $options: 'i' }; 
    }
    if (tid) {
        //获取最新5条评论                                          
        forumCommentService.getCommentList(conditions, pageNo, pageSize, function(err, results) {
            if (err) {
                console.log(err);
                res.json(returnCode.BUSY);
            } else {
                var asyncTasks = [];
                _.forEach(results.items,function(e){
                    asyncTasks.push(function(cb){
                        if(e.level == 1){
                            cb(null,e);
                        }else{
                            forumCommentService.getCommentParent(e._id,function(err,p_comment){
                                var comment = e.toObject();
                                comment.floor = p_comment.floor;
                                cb(null,comment);
                            });
                        }
                    });
                });
                async.parallel(asyncTasks,function(err,items){
                    results.items = items;
                    res.json(_.assign(results, returnCode.SUCCESS));
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//评论列表(根据楼层查询)
router.get('/thread/:tid/comment/list/:floor', function(req, res, next) {
    var tid = req.params.tid || null,
        floor = req.params.floor || null,
        content = req.query.content || '';
    var conditions = {
        ent_code: req.session.user.ent_code,
        thread: tid,
        level: '1',
        floor:floor
    };
    
    if (tid && floor) {
        forumCommentService.getAllComment(conditions, 1, 1, function(err, results) {
            if (err) {
                console.log(err);
                res.json(returnCode.BUSY);
            } else {
                var asyncTasks = [];
                if(results.items && results.items[0] && results.items[0].comments.length>0){
                    var items = [results.items[0]];
                    _.forEach(results.items[0].comments,function(e){
                        var subComment = e.toObject();
                        subComment.floor = results.items[0].floor;
                        if(content){
                            if(subComment.content.indexOf(content) != -1){
                                items.push(subComment);       
                            }
                        }else{
                            items.push(subComment);   
                        }
                    });
                    results.items = items;
                    results.total = items.length;
                    res.json(_.assign(results, returnCode.SUCCESS));
                }else{
                    res.json(_.assign(results, returnCode.SUCCESS));
                }
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

// 更新评论状态
router.post('/thread/comment/update/:cid', function(req, res, next) {
    var cid = req.params.cid || null;
    var status = req.body.status;
    if (cid) {
        async.waterfall([
            function(callback){
                //获取评论实例
                forumCommentService.getCommentById(cid,callback);
            },
            function(comment,callback){
                //更新评论状态
                forumCommentService.updateCommentStatusById(cid, status,function(err,update){
                    callback(err,comment);
                });
            },
            function(comment,callback){
                //是否删除评论
                if(status == 2){
                    //一级评论
                    if(comment.level == 1){
                        var commentList = result.comments;
                        var comments = forumThreadService.remove(commentList, cid);
                        forumThreadService.updateThreadById(comment.thread, {
                            comments:comments,
                            $inc: { comment_count: -1 }
                        }, function(err, result) {
                                callback(err);
                        });
                    }else{
                         forumThreadService.updateThreadCommentCount(comment.thread, function(err, result) {
                            if (err) {
                                callback(err);
                            }else{
                                // 更新评论的子评论列表
                                forumCommentService.getCommentParent(cid,function(err,p_comment){
                                    if(err || !p_comment){
                                        callback(err || 'comment not exist');
                                    }else{
                                        var commentList = p_comment.comments;
                                        var comments = forumCommentService.remove(commentList, cid);
                                        forumCommentService.updateCommentById(p_comment._id, {
                                            comments:comments
                                        }, function(err, update) {
                                            callback(err);
                                        });
                                    }
                                }); 
                            }
                        });
                    }
                }else{
                    callback();
                }
            }
        ],function(err,restult){
            if(err){
                console.error(err);
                res.json(returnCode.BUSY);
            }else{
                res.json(returnCode.SUCCESS);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

// 更新回复评论
router.post('/thread/comment/update/:cid/comments', function(req, res, next) {
    var tid = req.body.tid || null;
    var cid = req.params.cid || null;
    var replayComment_id = req.body.replayComment_id;
    // 获取评论的子评论列表
    // 更新文章评论 + 1

    forumThreadService.updateThreadCommentCountInc(tid, function(err, thread) {
        if (err) {
            console.error(err);
        }
    });
    // 更新评论对象
    //  result.comment_count+=1;                // 回复评论+1
    forumCommentService.updateCommentById(cid, {
        $push: {
            comments: replayComment_id
        },
        $inc: {
            comment_count: 1
        }
    }, function(err, result) {
        if (err) {
            console.error(err);
            res.json(returnCode.BUSY);
        } else {
            res.json(returnCode.SUCCESS);
        }
    });
});

// 更新评论的子评论列表
router.post('/thread/comment/update/:cid/comments', function(req, res, next) {
    var cid = req.params.cid || null;
    var replayComment_id = req.body.replayComment_id;


    forumCommentService.updateCommentById(cid, {
            $push: {
                comments: replayComment_id
            }
        },
        function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    // 获取评论的子评论列表
    // forumCommentService.getCommentById(cid, function(err, result) {
    //     if (err) {
    //         console.error(err);
    //         res.json(returnCode.BUSY);
    //     } else {
    //         // var commentList = result.comments;

    //         // result.comments.push(replayComment_id);

    //         forumCommentService.updateCommentById(cid, {
    //                 $push: {
    //                     comments: replayComment_id
    //                 }
    //             },
    //             function(err, result) {
    //                 if (err) {
    //                     console.error(err);
    //                     res.json(returnCode.BUSY);
    //                 } else {
    //                     res.json(returnCode.SUCCESS);
    //                 }
    //             });

    //     }
    // });
});

//添加评论
router.post('/thread/comment/add', function(req, res, next) {
    var tid = req.body.tid || null;
    var entity = req.body;
    entity.created = new Date();
    entity.ent_code = req.session.user.ent_code;
    entity.ip = getClientIP(req);

    var uid = req.session.user.id;
    if (tid) {
        async.waterfall([
            function(callback) {
                forumUserService.getUserByUid(uid, callback);
            },
            function(user,callback){
                //获取发表人
                if(!user){
                     var userentity = {
                        uid: uid,
                        nickName: req.session.user.name,
                        icon: req.session.user.headPic
                    };
                    forumUserService.createUser(userentity, function(err, doc) {
                        if (err) {
                            callback(err);
                        } else {
                            entity.from = doc._id;
                            callback();
                        }
                    });
                }else{
                    var icon  = req.session.user.headPic;
                    if(icon){
                        if(icon.indexOf('http://') == -1){
                            icon =  req.host != 'piplus.wxpai.cn'?'http://img3.wxpai.cn/'+ icon : 'http://img2.wxpai.cn/' + icon;
                        }
                        if(icon && (!user.icon || user.icon !==  icon)){
                            
                            forumUserService.updateUserById(user._id,{icon:icon},function(err){
                                if(err){
                                    console.log(err);    
                                }
                            });
                        }
                    }
                    
                    entity.from = user;
                    callback();
                }
            },
            function(callback){
                //获取楼层
                if(entity.level == 1){
                    var conditions = {
                        thread:entity.thread,
                        level:'1'
                    }
                    forumCommentService.count(conditions, function(err, count) {
                        if (err) {
                            callback(err);
                        } else {
                            if(count){
                                entity.floor = count + 1;
                            }else{
                                entity.floor = 1;
                            }
                            callback();
                        }
                    });
                }else{
                    callback();
                }
            },
            function(callback){
                // 添加评论
                forumCommentService.createComment(entity, function(err, comment) {
                    if (err) {
                        callback(err);
                    } else {
                        forumThreadService.getById(tid,function(err,thread){
                            var comments = thread.comments;
                            var array = [];
                            if (comments  && comments.length > 0) {
                                array = comments;
                            }
                            array.push(comment._id);
                            forumThreadService.updateThreadById(tid, {
                                comments: array,
                                $inc: {
                                    comment_count: 1
                                }
                            }, function(err, result) {
                                var returnData = {
                                    comment: comment,
                                    errorcode: 0,
                                    errormsg: '请求成功'
                                }
                                callback(null,returnData);
                            });
                        });
                    }
                });
            }
        ], function(err, returnData) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(returnData);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

// 更新文章评论
router.post('/thread/:tid/updateComments', function(req, res, next) {
    var tid = req.params.tid || null;
    var cid = req.body.cid || null;

    forumThreadService.updateThreadById(tid, {
            $push: {
                comments: cid
            },
            $inc: {
                comment_count: 1
            }
        },
        function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });

    // 获取评论的子评论列表
    // forumThreadService.getById(tid, function(err, result) {
    //     if (err) {
    //         console.error(err);
    //         res.json(returnCode.BUSY);
    //     } else {
    //         result.comments.push(cid);
    //         result.comment_count += 1;

    //         forumThreadService.updateThreadById(tid, result,
    //             function(err, result) {
    //                 if (err) {
    //                     console.error(err);
    //                     res.json(returnCode.BUSY);
    //                 } else {
    //                     res.json(returnCode.SUCCESS);
    //                 }
    //             });
    //     }
    // });
});

var checkOpenIds = function(openIds,openId){
    var restult = false;
    for(var i =0;i<openIds.length;i+=1){
        if(openIds[i] == openId){
            restult = true;
            break;
        } 
    }
    return restult;
};
var getSubSpreadPaths = function(openIds,c,pvs,cb){
        c.children = [];
        for(var i =0;i<pvs.length;i+=1){
            if(pvs[i].source.uid == c.openId){
                var flag = false;
                for(var j =0;j<c.children.length;j+=1){
                    if(c.children[j].openId == pvs[i].open_id){
                        flag = true;
                        break;
                    } 
                }
                if(!flag && !checkOpenIds(openIds,pvs[i].open_id)){
                    c.children.push({
                        openId:pvs[i].open_id,
                        nickName:pvs[i].user.displayName || '未知',
                        name:pvs[i].user.nickName || '未知'
                    });
                    openIds.push(pvs[i].open_id);
                }
            } 
        }
        var new_pvs = [];
        for(var i =0;i<pvs.length;i+=1){
            if(pvs[i].source.uid !== c.openId){
                new_pvs.push(pvs[i]);
            } 
        }
        pvs = new_pvs;
        if(c.children.length >0){
            var thenTask = [];
            _.forEach(c.children,function(c){
                thenTask.push(function(scb){
                    getSubSpreadPaths(openIds,c,pvs,scb);
                });
            })
            then.parallel(thenTask).then(function(cont,childrens){
                c.children = childrens;
                cb(null,c);
            });
        }else{
            cb(null,c);
        }
};
// 更新文章评论
router.get('/thread/:tid/spreadchain', function(req, res, next) {
    var tid = req.params.tid || null,
        ent_code = req.session.user.ent_code;
    var openIds = [];    
    then.parallel([
        function(cont){
            ForumThread.findOne({
                _id:tid,
                ent_code:ent_code
            }).populate('from').exec(function(err,doc){
                cont(err,doc);
            });
        },
        function(cont){
            ForumPVLog.find({
                thread:tid,
                ent_code:ent_code
            }).sort('source created').populate('user source').exec(function(err,docs){
                cont(err,docs);
            });
        }
    ]).then(function(cont,results){
        var thread = results[0],
            pvs = results[1];

        var data = {
            openId:thread.from.uid,
            name:thread.from.nickName,
            nickName:thread.from.displayName,
            children:[]
        }
        //获取一级传播
        for(var i = 0;i<pvs.length;i+=1){
            var pv = pvs[i];
            if(!pv.source){
                var flag = false;
                for(var j = 0;j<data.children.length;j+=1){
                    var c = data.children[j];
                    if(c.openId === pv.open_id){
                        flag = true;
                        break;
                    }
                }
                if(!flag && pv.open_id !== data.openId &&  !checkOpenIds(openIds,pv.open_id)){
                    data.children.push({
                        openId:pv.open_id,
                        nickName:pv.user.displayName || '未知',
                        name:pv.user.nickName || '未知'
                    });
                    openIds.push(pv.open_id);    
                }
            }
        } 
        //获取非一级传播
        var new_pvs = [];
        for(var i = 0;i<pvs.length;i+=1){
            if(pvs[i].source && pvs[i].source.uid !== data.openId && pvs[i].open_id !== data.openId){
                new_pvs.push(pvs[i]);
            }
        }
        pvs = new_pvs;
        //递归其他传播
        var thenTask = [];
        _.forEach(data.children,function(c){
            thenTask.push(function(cb){
                getSubSpreadPaths(openIds,c,pvs,cb);
            });
        })
        then.parallel(thenTask).then(function(cont,childrens){
            data.children = childrens;
            var rs = {
                data:data
            }    
            openIds = [];
            res.json(_.assign(rs, returnCode.SUCCESS));  
        });
        
    }).fail(function(cont,err){
        console.error(err);
        res.json(returnCode.BUSY);
    });
});


//给以前的已一级评论添加楼层
// router.get('/thread/updateConmentFloor', function(req, res, next) {
//     res.json(returnCode.SUCCESS);
//     var conditions = {
//         // ent_code: ent_code
//     }; 
//     async.waterfall([
//         function(callback) { // 查找文章的总数
//             forumThreadService.getAllCountByFid(conditions,function(err, count){
//                 if(err){
//                     callback(err, null);
//                 }else{
//                     callback(null, count);
//                 }
//             }); 
//         },
//         function(count, callback) { //查找所有文章
//             forumThreadService.getAllThreadByFidNoLimit(conditions, 1, count, null, function(err, datas){
//                 if(err){
//                     callback(err, null);
//                 }else{
//                     callback(null, datas);
//                 }
//             });
//         }
//     ], function (err, result) {
//         var asyncTasks = [];
//         result.items.forEach(function(doc, t) { //遍历文章
//             asyncTasks.push(function(callback2) {
//                 //获取文章所有一级评论
//                 var conditions = {
//                     thread: doc._id,
//                     level: '1'
//                 };
//                 async.waterfall([
//                     function(callback) {
//                         //统计评论数                                        
//                         forumCommentService.count(conditions, function(err, count) {
//                             if (err) {
//                                 console.log(err);
//                                 callback(err, null);
//                             } else {
//                                 callback(null, count);
//                             }
//                         });
//                     },
//                     function(count, callback) {
//                         //获取所有评论                                         
//                         forumCommentService.getAllComment(conditions, 1, count, function(err, results) {
//                             if (err) {
//                                 console.log(err);
//                                 callback(err, null);
//                             } else {
//                                 callback(null, results.items);
//                             }
//                         });
//                     },
//                     function(comments, callback) {
//                         comments = _.sortBy(comments, function(comment){ 
//                             return comment.created;
//                         });
//                         if(comments.length > 0){
//                             // 给每一个评论添加楼层
//                             comments.forEach(function(comment,i){
//                                 forumCommentService.updateCommentFloorById(comment._id, i + 1, function(err,docc){
//                                     if (err) {
//                                         console.error(err);
//                                         // callback(err,null);
//                                     } else {
//                                         console.log('update '+i+1+' comment');
//                                         // callback(null,null);
//                                     }

//                                 })
//                             });
//                         }
//                     }
//                 ], function(err, resultsss) {
//                     if (err) {
//                         console.error(err);
//                         // callback(err,null);
//                     } else {
//                         // callback2(null,null);
//                     }
//                 });
//             });

//         });
//         async.parallel(asyncTasks, function(err, results) {
//             if (err) {
//                 console.error(err);
//                 res.json(returnCode.BUSY);
//             } else {
//                 // console.log("------------update done!-------------");
//                 res.json(returnCode.SUCCESS);
//             }
//         });
//     });
// });
