

'use strict';
var mongoose = require('mongoose');
var ForumComment = mongoose.model('ForumComment');

var async=require('async');

//创建评论
exports.createComment=function(entity,callback){
	var forum = new ForumComment(entity);
	forum.save(function(err, forum) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,forum);
		}
	});
};

//根据ID获取评论
exports.getCommentById=function(cid,callback){
	ForumComment.findById(cid, function(err, comment) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,comment);
		}
	});
};

//根据ID更新评论
exports.updateCommentStatusById=function(cid,status,callback){
	ForumComment.update({ _id: cid}, {"status" : status},null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//根据ID更新评论
exports.updateCommentFloorById=function(cid,floor,callback){
	ForumComment.update({ _id: cid}, {"floor" : floor},null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//根据ID更新评论 entity
exports.updateCommentById=function(cid,entity,callback){
	ForumComment.update({ _id: cid}, entity, null, function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};


//根据ID删除评论
exports.deleteCommentById=function(cid,callback){
	ForumComment.remove({ _id: cid},function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//获取数量
function countAll(conditions,callback) {
	ForumComment.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//获取数量
exports.count = function(conditions,callback) {
	ForumComment.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//获取全部列表数据
exports.getAllComment= function(conditions,pageNo,pageSize,callback) {

	countAll(conditions,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);

		    ForumComment.find(conditions).populate('from').populate('to').limit(limit).skip(skip).sort('-created').exec(function(err, docs) {
		    	if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;

					if (docs && docs.length > 0) {
						var asyncTasks = [];
						docs.forEach(function(doc){
							asyncTasks.push(function(callback) {
				                populateComment(doc, function(err,c){
				                	if(err){
				                		callback(err,null);
				                	}else{
				                		var newobj = doc.toObject();
	                					newobj.comments = (c==null?[]:c);
	                					callback(null,newobj);
				                	}
				                });
				            });
						});
						async.parallel(asyncTasks, function(err, results) {
						    if (err) {
						        console.log(err);
						        callback(null, null);
						    } else {
						    	obj.items=results;
						        callback(null,obj);
						    }
						});
						
					}else{
						callback(null,obj);
					}
				}
		    });
		}
	});
};

//评论
function populateComment(doc, callback){
	if (doc && doc.comments.length > 0) {
		var asyncTasks = [];
		doc.comments.forEach(function(comment){
			asyncTasks.push(function(callback) {
				ForumComment.findOne({_id: comment,status:1}).populate({path:'from to', select:'uid nickName icon'}).exec(function(err,c){
					if (err) {
                		console.error(err);
                		callback(null, null);
                	} else{
                		if(c){
                			callback(null ,c);		
                		}else{
                			callback(null);		
                		}
                	}
				});
            });
		});
		async.parallel(asyncTasks, function(err, results) {
		    if (err) {
		        console.log(err);
		        callback(null, null);
		    } else {
		    	var comments = [];
		    	for(var i=0;i<results.length;i+=1){
		    		if(results[i]){
		    			comments.push(results[i]);
		    		}
		    	}
		        callback(null,comments);
		    }
		});

	} else{
		callback(null, null);
	}
}

//原子更新评论点赞数
exports.updatePraiseCount=function(cid,callback){
	ForumComment.update(
							{_id:cid}, 
							{$inc: {praise_count: 1 }},
							{w:1,safe:true},
							function(err,result){
								if(err){
									console.error(err);
									callback(err,null);
								}else{
									callback(null,null);
								}
							});
};

//原子更新评论点赞数
exports.updateCommentCount=function(cid,callback){
	ForumComment.update(
							{_id:cid}, 
							{$inc: {comment_count: 1 }},
							{w:1,safe:true},
							function(err,result){
								if(err){
									console.error(err);
									callback(err,null);
								}else{
									callback(null,null);
								}
							});
};

// 查找数组元素下标
function indexOf(array,val) {
    for (var i = 0; i < array.length; i++) {
        if (array[i] == val) return i;
    }
    return -1;
};

// 删除数组指定值
exports.remove = function(array,val) {
    var index = indexOf(array,val);
    if (index > -1) {
        array.splice(index, 1);
    }
    return array;
};
//更改评论状态
exports.changeStatus = function(cid,status,callback){
	ForumComment.update(
		{_id:cid},
		{status:status},
		function(err,update){
			callback(err,update);
		}
	);
};
//获取评论列表 
exports.getCommentList = function(conditions,pageNo,pageSize,callback){
	countAll(conditions,function(err,count){
		if(err){
			callback(err);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);

		    ForumComment.find(conditions).populate('from').populate('to').limit(limit).skip(skip).sort('-created').exec(function(err, docs) {
		    	if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;

					callback(null,obj);
				}
		    });
		}
	});
};
exports.getCommentParent = function(cid,callback){
	ForumComment.findOne({comments:{$in:[cid]}},function(err,doc){
		callback(err,doc);
	});
};

//根据ID获取评论
exports.getPopulateCommentById=function(cid,callback){
	ForumComment.findById({_id:cid}).populate({path:'from to', select:'uid nickName icon'}).exec(function(err,c){
		if (err) {
    		console.error(err);
    		callback(null, null);
    	} else{
			callback(null ,c);
    	}
	});
};



//我的评论
var countMyComment = function(conditions,callback) {
	ForumComment.find(conditions)
	.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
};

function populateParentComment(doc, callback){
	if (doc && doc._id && doc.level === 2) {
		ForumComment.findOne({comments: { $elemMatch : doc._id },status:1}).exec(function(err,c){
			if (err) {
				console.error(err);
				callback(null, null);
			} else{
				if(c){
					callback(null ,c);		
				}else{
					callback(null);		
				}
			}
		});
	} else{
		callback(null, null);
	}
}
//我的评论
exports.getMyComment = function(conditions,pageNo,pageSize,callback){
	countMyComment(conditions,function(err,count){
		if(err){
			callback(err);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);

		    ForumComment.find(conditions)
			.populate({
				path: 'thread',
				select: '_id content title type level tag'
			}).populate({path:'from to', select:'uid nickName icon'}).limit(limit).skip(skip).sort('-created').exec(function(err, docs) {
		    	if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;
					
					if (docs && docs.length > 0) {
						var asyncTasks = [];
						docs.forEach(function(doc){
							asyncTasks.push(function(callback) {
				                populateParentComment(doc, function(err,c){
				                	if(err){
				                		callback(err,null);
				                	}else{
				                		var newobj = doc.toObject();
	                					newobj.parent = c;
										delete newobj.comments;
	                					callback(null,newobj);
				                	}
				                });
				            });
						});
						async.parallel(asyncTasks, function(err, results) {
						    if (err) {
						        console.log(err);
						        callback(null, null);
						    } else {
						    	obj.items=results;
						        callback(null,obj);
						    }
						});
						
					}else{
						callback(null,obj);
					}
				}
		    });
		}
	});
};