'use strict';
var mongoose = require('mongoose');
var ForumUser = mongoose.model('ForumUser');
var then = require('thenjs');
var async = require('async');
var forumLimitActionRefService = require('../service/forumLimitActionRefService');
var forumLimitActionConfigService = require('../service/forumLimitActionConfigService');
//创建用户
exports.createUser=function(entity,callback){
	var forum = new ForumUser(entity);
	forum.save(function(err, forum) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,forum);
		}
	});
};

//根据Uid获取用户
exports.getUserByUid=function(uid,callback){
	ForumUser.findOne({uid:uid}).exec(function(err,result){
		if(err){
			callback(err,null);
		}else{
			if(result ){
				callback(null,result);
			}else{
				callback(null,null);
			}
		}
	});
};

//根据id获取用户
exports.getUserById=function(id,callback){
	ForumUser.findOne({_id:id}).exec(function(err,result){
		if(err){
			callback(err,null);
		}else{
			if(result ){
				callback(null,result);
			}else{
				callback(null,null);
			}
		}
	});
};

//根据ID更新用户信息
exports.updateUserById=function(uid,entity,callback){
	ForumUser.update({ _id: uid}, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//查询用户信息
exports.searchMembers=function(pageNo, pageSize, q, callback){
	then(function(cont) {
        ForumUser.find(q).count(cont);
    }).then(function(cont, count) {
        var skip = (pageNo - 1) * pageSize;
        var limit = count - skip > pageSize ? pageSize : (count - skip);
        ForumUser.find(q).skip(skip).limit(limit).sort('-created').exec(function(err, docs) {
            cont(err, count, docs);
        });
    }).then(function(cont, count, members) {
        var rsJson = {
            result: true,
            total: count,
            datas: members
        };
        callback(null, rsJson);
    }).fail(function(cont, err) {
        console.error(err);
        var rsJson = {
            result: false,
            err: err
        };
        callback(err, rsJson);
    });
};

//查询用户和行为限制信息
exports.searchMembersAndLimitActions=function(pageNo, pageSize, q, callback){
	then(function(cont) {
        ForumUser.find(q).count(cont);
    }).then(function(cont, count) {
        var skip = (pageNo - 1) * pageSize;
        var limit = count - skip > pageSize ? pageSize : (count - skip);
        ForumUser.find(q).skip(skip).limit(limit).sort('-created').exec(function(err, docs) {
            cont(err, count, docs);
        });
    }).then(function(cont, count, members) {
    	forumLimitActionConfigService.getAllLimitActionConfig(function(err, configs) {
    		cont(err, count, members, configs);
    	});
    }).then(function(cont, count, members, configs) {
    	if (count > 0 && configs.length > 0) {
	        var asyncTasks = [];
	        members.forEach(function(member) {
	            asyncTasks.push(function(callback) {
	            	forumLimitActionRefService.getLimitActionRefByMIdAndEntCode(member._id, member.ent_code, function(err, forumLimitActionRef) {
			            if (err) {
	                        console.error(err);
	                        callback(null, null);
	                    } else {
	                    	if(forumLimitActionRef){
	                    		var limit_actions = forumLimitActionRef.limit_actions;
		                    	var array = [];
				                for (var i = 0; i < limit_actions.length; i += 1) {
				                    var limit_action = limit_actions[i];
				                    for(var k = 0; k < configs.length; k+=1){
				                    	if(limit_action.limit_action_type === configs[k].code){
				                    		array.push(configs[k].name);
				                    		break;
				                    	}
				                    }
				                }
				                member = member.toObject();
				                member.limitActions = array;
				                callback(null, member);
	                    	}else{
	                    		callback(null, member);
	                    	}
	                    }
			        });
	            });
	        });
	        async.parallel(asyncTasks, function(err, results) {
	            if (err) {
	                console.log(err);
	                callback(null, null);
	            } else {
	                // callback(null, results);
	                var rsJson = {
			            result: true,
			            total: count,
			            datas: results
			        };
			        callback(null, rsJson);
	            }
	        });

	    } else {
	        var rsJson = {
	            result: true,
	            total: count,
	            datas: members
	        };
	        callback(null, rsJson);
	    }
    }).fail(function(cont, err) {
        console.error(err);
        var rsJson = {
            result: false,
            err: err
        };
        callback(err, rsJson);
    });
};



//根据nickName查询用户
exports.searchMembersByNickName=function(nickName, callback){
	var name = {
		$or : [
			{nickName : { $regex: nickName, $options: 'i' }},
			{displayName : { $regex: nickName, $options: 'i' }}
		]
	};
    ForumUser.find(name).exec(function(err,result){
		if(err){
			callback(err,null);
		}else{
			callback(null,result);
		}
	});
};