'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');

var mongoose = require('mongoose');
var ForumInfo = mongoose.model('ForumInfo');
var forumInfoService = require('../../service/forumInfoService');
var forumThreadService = require('../../service/forumThreadService');
var forumUserThreadControlService = require('../../service/forumUserThreadControlService');
var httpService = require('../../service/httpService');

var user = require('../../utils/user');

var async = require('async');

module.exports = function(app) {
    app.use('/v1/forum', router);
};

//新增论坛板块
router.post('/info/create', function(req, res, next) {
    var rs = {};
    req.body.ent_code = req.session.user.ent_code;
    forumInfoService.createInfo(req.body, function(err, info) {
        if (err) {
            console.error(err);
            res.json(returnCode.BUSY);
        } else {
            rs.data = {
                'id': info._id
            };
            res.json(_.assign(rs, returnCode.SUCCESS));
        }
    });
});


//获取目标论坛板块
router.get('/info/:fid/get', function(req, res, next) {
    var fid = req.params.fid || null;
    if (fid) {
        var source = req.session.mobileForumUser.source;
        httpService.createLog(req,source,fid,2);
        async.waterfall([
            function(callback) {
                //更新浏览数
                forumInfoService.updateInfoPvCount(fid, function(err, result) {
                    if (err) {
                        callback(err, null);
                    } else {
                        callback(null, null);
                    }
                });
            },
            function(data, callback) {
                forumInfoService.getInfoById(fid, function(err, info) {
                    if (err) {
                        callback(err, null);
                    } else {
                        callback(null, info);
                    }
                });
            },
            function(info, callback) {
                forumThreadService.getAllCountByFid({
                    info: fid
                }, function(err, threadCount) {
                    if (err) {
                        callback(err, null, null);
                    } else {
                        callback(null, info, threadCount);
                    }
                });
            }
        ], function(err, info, threadCount) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                var rs = {};
                rs.data = info;
                rs.data.threadCount = threadCount;
                res.json(_.assign(rs, returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }

});

//更新目标论坛板块
router.post('/info/:fid/update', function(req, res, next) {
    var fid = req.params.fid;
    if (fid) {
        forumInfoService.updateInfoById(fid, req.body, function(err, result) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//删除目标论坛板块
router.post('/info/:fid/delete', function(req, res, next) {
    var fid = req.params.fid;
    if (fid) {
        forumInfoService.deleteInfoById(fid, function(err, result) {
            if (err) {
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

/**
 * [description]
 * @param  {[type]}
 * @param  {[type]}
 * @param  {[type]}
 * @return {[type]}
 */
router.get('/info/:fid/threads', function(req, res, next) {
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var fid = req.params.fid;
    var sort = '-top -topTime -created'
    var conditions = {
        ent_code: req.session.user.ent_code,
        level: 1,
        status:1
    };
    if (fid) {
        conditions.info = fid;
    }
    if (fid) {
        async.waterfall([
            function(callback) {
                forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req), function(err, doc) {
                    if (err) {
                        callback(err, null);
                    } else {
                        if (doc) {
                            callback(null, doc);
                        } else {
                            callback(null, null);
                        }
                    }
                });
            }
        ], function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (result) {
                    conditions._id = {
                        $nin: result.thread
                    };
                }
                forumThreadService.getAllThreadByFid(conditions, pageNo, pageSize, sort, function(err, results) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        res.json(_.assign(results, returnCode.SUCCESS));
                    }
                });
            }
        });

    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//获取论坛最热文章列表
router.get('/info/:fid/hotThreads', function(req, res, next) {
    var fid = req.params.fid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

    var conditions = {
        ent_code: req.session.user.ent_code,
        level: 1,
        info: fid
    };

    if (fid) {

        async.waterfall([
            function(callback) {
                forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req), function(err, doc) {
                    if (err) {
                        callback(err, null);
                    } else {
                        if (doc) {
                            callback(null, doc);
                        } else {
                            callback(null, null);
                        }
                    }
                });
            }
        ], function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (result) {
                    conditions._id = {
                        $nin: result.thread
                    };
                }
                forumThreadService.getAllThreadByFid(conditions, pageNo, pageSize, '-comment_count -praise_count', function(err, results) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        res.json(_.assign(results, returnCode.SUCCESS));
                    }
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//获取论坛晒图文章列表
router.get('/info/:fid/photoThreads', function(req, res, next) {
    var fid = req.params.fid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

    var conditions = {
        ent_code: req.session.user.ent_code,
        level: 1,
        info: fid,
        type: 3
    };

    if (fid) {

        async.waterfall([
            function(callback) {
                forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req), function(err, doc) {
                    if (err) {
                        callback(err, null);
                    } else {
                        if (doc) {
                            callback(null, doc);
                        } else {
                            callback(null, null);
                        }
                    }
                });
            }
        ], function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (result) {
                    conditions._id = {
                        $nin: result.thread
                    };
                }
                forumThreadService.getAllThreadByFid(conditions, pageNo, pageSize, null, function(err, results) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        res.json(_.assign(results, returnCode.SUCCESS));
                    }
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//获取我的文章列表
router.get('/info/:fid/myThreads', function(req, res, next) {
    var fid = req.params.fid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

    var conditions = {
        ent_code: req.session.user.ent_code,
        from: user.getMobileUser(req),
        info: fid
    };

    if (fid) {

        async.waterfall([
            function(callback) {
                forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req), function(err, doc) {
                    if (err) {
                        callback(err, null);
                    } else {
                        if (doc) {
                            callback(null, doc);
                        } else {
                            callback(null, null);
                        }
                    }
                });
            }
        ], function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (result) {
                    conditions._id = {
                        $nin: result.thread
                    };
                }
                //获取子话题数据
                forumThreadService.getAllThreadByFid(conditions, pageNo, pageSize, '-praise_count', function(err, results) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        res.json(_.assign(results, returnCode.SUCCESS));
                    }
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//搜索文章列表
router.get('/info/:fid/serachThreads', function(req, res, next) {
    var fid = req.params.fid || null;
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var content = req.query.content;

    var conditions = {
        ent_code: req.session.user.ent_code,
        info: fid
    };

    if (content) {
        conditions.content = {
            $regex: content,
            $options: 'i'
        };
    }

    if (fid) {

        async.waterfall([
            function(callback) {
                forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req), function(err, doc) {
                    if (err) {
                        callback(err, null);
                    } else {
                        if (doc) {
                            callback(null, doc);
                        } else {
                            callback(null, null);
                        }
                    }
                });
            }
        ], function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                if (result) {
                    conditions._id = {
                        $nin: result.thread
                    };
                }
                //获取子话题数据
                forumThreadService.getAllThreadByFid(conditions, pageNo, pageSize, '-praise_count', function(err, results) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        res.json(_.assign(results, returnCode.SUCCESS));
                    }
                });
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});
