'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');
var mongoose = require('mongoose');

var forumTagService=require('../../service/forumTagService');
var forumThreadService=require('../../service/forumThreadService');
var forumUserThreadControlService=require('../../service/forumUserThreadControlService');

var user=require('../../utils/user');
var async=require('async');

module.exports = function(app) {
	app.use('/v1/forum', router);
};

//查询所有标签
router.get('/tag/list', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var conditions={
    	ent_code:req.session.user.ent_code
    };
	forumTagService.getAllTag(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});

//查询前台可使用的所有标签（针对发帖）
router.get('/tag/mobileList', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var conditions={
    	ent_code:req.session.user.ent_code,
    	type:1
    };
	forumTagService.getAllTag(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});



//查询标签下的文章列表
router.get('/tag/:tid/threads', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var tid=req.params.tid;
    var sort = '-tag_top -tag_topTime -created';
    var conditions={
    	ent_code:req.session.user.ent_code,
    	status:1,
    	level:1
    };
    if(tid){
    	conditions.tag={$in:[tid]};

    	async.waterfall([
    			function(callback){
    				forumUserThreadControlService.getUserThreadControlById(user.getMobileUser(req),function(err,doc){
						if(err){
							callback(err,null);
						}else{
							if(doc){
								callback(null,doc);
							}else{
								callback(null,null);
							}
						}
					});
    			}
    		],function(err,result){
    			if(err){
					console.error(err);
					res.json(returnCode.BUSY);
				}else{
					if(result){
						conditions._id={$nin:result.thread};
					}
					forumThreadService.getAllThreadByFid(conditions,pageNo,pageSize,sort,function(err,results){
						if(err){
							console.error(err);
							res.json(returnCode.BUSY);
						}else{
							res.json(_.assign(results, returnCode.SUCCESS));
						}
					});
				}
    	});
    }else{
    	res.json(returnCode.WRONG_PARAM);
    }
});