'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');

var mongoose = require('mongoose');
var forumUserService=require('../../service/forumUserService');
var forumThreadService=require('../../service/forumThreadService');

var async=require('async');

var user=require('../../utils/user');

module.exports = function(app) {
	app.use('/v1/forum', router);
};

//获取用户信息
router.get('/user/get', function(req, res, next) {
	var rs = {};
	async.parallel([
			function(cb){
				forumUserService.getUserById(user.getMobileUser(req),function(err,entity){
					if (err) {
						cb(err,null);
					} else {
						cb(null,entity);
					}
				});
			},
			function(cb){
				var conditions={
					ent_code:req.session.user.ent_code,
					from:user.getMobileUser(req)
				};
				forumThreadService.getAllCountByFid(conditions,function(err,count){
					if (err) {
						cb(err,null);
					} else {
						cb(null,count);
					}
				});
			}
		],function(err,results){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				rs.data = results[0] || {};
				rs.myThreadCount=results[1] || 0;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
	});	
});

//获取用户信息
router.post('/user/:uid/update', function(req, res, next) {
	var uid=req.params.uid;
	if(uid){
		forumUserService.updateUserById(uid,req.body,function(err,result){
			if(err){
				res.json(returnCode.BUSY);
			}else{
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});