'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash'),
	moment = require('moment'),
	nodeExcel = require('excel-export'),
	then = require('thenjs');

var mongoose = require('mongoose');
var ForumInfo = mongoose.model('ForumInfo');
var forumInfoService=require('../../service/forumInfoService');
var forumThreadService=require('../../service/forumThreadService');
var forumGroupService = require('../../service/forumGroupService');
var ForumThread = mongoose.model('ForumThread');
var ForumUvLog = mongoose.model('ForumUVLog');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//格式化日期 (格式：年-月-日)
function date_format(date) {
    return moment(date).format('YYYY/MM/DD');
}

//获取日期之间所有日期
function get_all_date(begin, end) {
    var date_array = [];
    // if (begin === end) return date_array;
    if (begin === end){
        date_array.push(end.replace(/-/g, "/"));
        return date_array;
    } 
    var ab = begin.split('-');
    var ae = end.split('-');
    var db = new Date();
    db.setUTCFullYear(ab[0], ab[1] - 1, ab[2]);
    var de = new Date();
    de.setUTCFullYear(ae[0], ae[1] - 1, ae[2]);
    var unixDb = db.getTime();
    var unixDe = de.getTime() + 24 * 60 * 60 * 1000;
    for (var k = unixDb; k < unixDe;) {
        date_array.push(date_format(new Date(parseInt(k))));
        k = k + 24 * 60 * 60 * 1000;
    }
    return date_array;
}

//统计
function mapReduce(model, match, group, date, callback) {
    model.aggregate({
            $match: match
        }, {
            $group: group
        },
        function(err, res) {
            if (err) callback(err);
            else {
                var data = {
                    date: date,
                    count: res.length
                };
                callback(null, data);
            }
        });
}

//新增论坛板块
router.post('/info/create', function(req, res, next) {
	var rs = {};
	var entity = req.body;
	var ent_code = entity.ent_code = req.session.user.ent_code;
	then(function(cont){
		//获取所有版块组
		forumGroupService.getAll({ent_code:ent_code},1,100,function(err,groups){
			cont(err,groups);
		});
	}).then(function(cont,groups){
		//判断是否存在版块组
		if(groups && groups.items.length >0){
			cont(null,groups.items[0]);
		}else{
			//创建默认版块组1
			var group = {
				name:'默认分组',
				ent_code:ent_code
			};
			forumGroupService.createGroup(group,function(err,group){
				cont(err,group);
			});
		}
	}).then(function(cont,group){
		if(group){
			//创建版块
			entity.group = group._id;
			forumInfoService.createInfo(req.body,function(err,info){
				cont(err,info);
			});	
		}else{
			cont('group error');
		}
	}).then(function(cont,info){
		rs.data = {'id':info._id};
		res.json(_.assign(rs, returnCode.SUCCESS));
	}).fail(function(err,cont){
		console.error(err);
		res.json(returnCode.BUSY);
	});
});

//获取目标论坛板块
router.get('/info/:fid/get', function(req, res, next) {
	var fid = req.params.fid || null;
	var rs = {};
	if (fid) {
		forumInfoService.getInfoById(fid,function(err,info){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				rs.data = info;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});
	} else {
		res.json(returnCode.WRONG_PARAM);
	}
});

//更新目标论坛板块
router.post('/info/:fid/update', function(req, res, next) {
	var fid=req.params.fid;
	if(fid){
		forumInfoService.updateInfoById(fid,req.body,function(err,result){
			if(err){
				res.json(returnCode.BUSY);
			}else{
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//删除目标论坛板块
router.post('/info/:fid/delete', function(req, res, next) {
	var fid=req.params.fid;
	if(fid){
		forumInfoService.deleteInfoById(fid,function(err,result){
			if(err){
				res.json(returnCode.BUSY);
			}else{
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

/**
 * [description]
 * @param  {[type]}
 * @param  {[type]}
 * @param  {[type]}
 * @return {[type]}
 */
router.get('/info/:fid/threads', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var fid=req.params.fid;

	if(fid){
		var conditions={
	    	ent_code:req.session.user.ent_code,
	    	info:fid
	    };
		forumThreadService.getAllThreadByFid(conditions,pageNo,pageSize,null,function(err,results){
			if(err){
				console.error(err);
				res.json(returnCode.BUSY);
			}else{
				res.json(_.assign(results, returnCode.SUCCESS));
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

/**
 * [description]
 * @param  {[type]}
 * @param  {[type]}
 * @param  {[type]}
 * @return {[type]}
 */
router.get('/infos/list', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var groupId=req.query.groupId || null;
    var infoName=req.query.infoName || null;
    var conditions={
    	ent_code:req.session.user.ent_code
    };
    if(groupId){
    	conditions.group=groupId;
    }
	if(infoName){
    	conditions.name={
    		$regex: infoName,
			$options: 'i'
    	};
    }
	forumInfoService.getAllByGid(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});

//直接修改序号
router.put('/infos/orderIDX/:id/:order', function(req, res, next) {
	var id=req.params.id;
    var idx=req.params.order;
	forumInfoService.updateInfoIdx(id,idx,function(err,result){
		if(err ||　!result){
			return res.json(returnCode.BUSY);
		}
		return res.json(_.assign({data:true}, returnCode.SUCCESS));
	});
});
//板块上移
router.put('/infos/moveUP/:id/:order', function(req, res, next) {
    var id=req.params.id;
    var idx=req.params.order;
    var groupId=req.body.groupId || null;
    var infoName=req.body.infoName || null;
    var conditions={
        ent_code:req.session.user.ent_code
    };
    if(groupId){
        conditions.group=groupId;
    }
    if(infoName){
        conditions.name={
            $regex: infoName,
            $options: 'i'
        };
    }
    forumInfoService.getAllOrderIDX(conditions,function(err,results){
        if(err){
            return res.json(returnCode.BUSY);
        }
        var index=-1;
        _.forEach(results,function(r,i){
            if(r._id.toString() === id.toString()){
                index=i;
            }
        });
        if(index === -1){
            return res.json(returnCode.BUSY);
        }
        var preObj=results[index-1];
        if(!preObj){
            return res.json(returnCode.BUSY);
        }
        var preidx=preObj.order_idx;
        if(preidx.toString() === idx.toString()){
            preidx = Number(preidx)+1;
        }
        forumInfoService.updateInfoIdx(id,preidx,function(err,result){
            if(err ||　!result){
                return res.json(returnCode.BUSY);
            }
            forumInfoService.updateInfoIdx(preObj._id,idx,function(err,result){
                if(err ||　!result){
                    return res.json(returnCode.BUSY);
                }
                return res.json(_.assign({data:true}, returnCode.SUCCESS));
            });
        });
    });
});

//子板块报表
router.post('/info/report/:id', function(req, res, next) {
    // 1.获取文章的创建日期,和今天的日期,转换成日期数组
    var info_id = req.body.id,
        ent_code = req.session.user.ent_code,
        begin_time = req.body.begin_time,
        end_time = req.body.end_time,
        all_data_array = get_all_date(begin_time, end_time);


    if (begin_time && end_time) {
        var uv_datas = [];
        var thread_datas = [];

        //统计UV
        var uv_tasks = [];
        _.forEach(all_data_array, function(d) {
            uv_tasks.push(function(cont) {
                var match = {
                    ent_code:ent_code,
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    },
                    info: info_id
                };
                var group = {
                    _id: {
                        user: '$user'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumUvLog, match, group, d, cont);
            });
        });

        //统计发帖数
        var thread_tasks = [];
        _.forEach(all_data_array, function(d) {
            thread_tasks.push(function(cont) {
                var match = {
                    ent_code:ent_code,
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    },
                    info: info_id
                };
                var group = {
                    _id: {
                        _id: '$_id'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumThread, match, group, d, cont);
            });
        });

        then.parallel([function(con) {
            //UV
            then.parallel(uv_tasks).then(function(cont, datas) {
                uv_datas = datas;
                con();
            }).fail(function(cont, err) {
                con();
            });
        }, function(con) {
            //发帖数
            then.parallel(thread_tasks).then(function(cont, datas) {
            	// console.log(datas);
                thread_datas = datas;
                con();
            }).fail(function(cont, err) {
                console.log(err);
                con();
            });
        }]).then(function(cont, datas) {
            var data = {
                uv_datas: uv_datas,
                thread_datas: thread_datas
            }

            res.json({
                result: true,
                errcode: 0,
                data: data,
                date_array: all_data_array
            });
        }).fail(function(cont, err) {
            console.error(err);
            res.json({
                result: false,
                err: err
            });
        });
    } else {
        res.json({
            result: false,
            err: '参数不合法'
        });
    }
});



//导出子板块报表
router.get('/info/report/exportXlsReport/:id', function(req, res, next) {
	var info_id = req.params.id,
        ent_code = req.session.user.ent_code,
        begin_time = req.query.begin_time,
        end_time = req.query.end_time,
        all_data_array = get_all_date(begin_time, end_time);

    if (begin_time && end_time) {

        forumInfoService.getInfoById(info_id,function(err,info){
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                var uv_datas = [];
                var thread_datas = [];

                //统计UV
                var uv_tasks = [];
                _.forEach(all_data_array, function(d) {
                    uv_tasks.push(function(cont) {
                        var match = {
                            ent_code:ent_code,
                            created: {
                                $gte: new Date(d + ' 00:00:00'),
                                $lte: new Date(d + ' 23:59:59')
                            },
                            info: info_id
                        };
                        var group = {
                            _id: {
                                user: '$user'
                            },
                            count: {
                                $sum: 1
                            }
                        };
                        mapReduce(ForumUvLog, match, group, d, cont);
                    });
                });

                //统计发帖数
                var thread_tasks = [];
                _.forEach(all_data_array, function(d) {
                    thread_tasks.push(function(cont) {
                        var match = {
                            ent_code:ent_code,
                            created: {
                                $gte: new Date(d + ' 00:00:00'),
                                $lte: new Date(d + ' 23:59:59')
                            }
                        };
                        var group = {
                            _id: {
                                _id: '$_id'
                            },
                            count: {
                                $sum: 1
                            }
                        };
                        mapReduce(ForumThread, match, group, d, cont);
                    });
                });

                then.parallel([function(con) {
                    //UV
                    then.parallel(uv_tasks).then(function(cont, datas) {
                        uv_datas = datas;
                        con();
                    }).fail(function(cont, err) {
                        con();
                    });
                }, function(con) {
                    //发帖数
                    then.parallel(thread_tasks).then(function(cont, datas) {
                        // console.log(datas);
                        thread_datas = datas;
                        con();
                    }).fail(function(cont, err) {
                        console.log(err);
                        con();
                    });
                }]).then(function(cont, datas) {
                    var conf = {};
                    conf.cols = [
                        {caption:'日期', type:'string'},
                        {caption:'访问人数', type:'number'},
                        {caption:'发帖数', type:'number'}
                    ];
                    conf.rows = [];     
                    for(var i =0;i<all_data_array.length;i+=1){
                        conf.rows.push(
                            [
                                all_data_array[i],
                                uv_datas[i].count,
                                thread_datas[i].count
                            ]
                        );
                    }    

                    var filename = info.name + '报表.xlsx';
                    var userAgent = (req.headers['user-agent']||'').toLowerCase();
 
                    if(userAgent.indexOf('msie') >= 0 || userAgent.indexOf('chrome') >= 0) {
                        res.setHeader('Content-Disposition', 'attachment; filename=' + encodeURIComponent(filename));
                    } else if(userAgent.indexOf('firefox') >= 0) {
                        res.setHeader('Content-Disposition', 'attachment; filename*="utf8\'\'' + encodeURIComponent(filename)+'"');
                    } else {
                        /* safari等其他非主流浏览器只能自求多福了 */
                        res.setHeader('Content-Disposition', 'attachment; filename=' + new Buffer(filename).toString('binary'));
                    }

                    var result = nodeExcel.execute(conf);
                    res.setHeader('Content-Type', 'application/vnd.ms-excel;charset=utf-8');
                    // res.setHeader('Content-Disposition', 'attachment; filename=InfoReport.xlsx');
                    res.end(result, 'binary');
                }).fail(function(cont, err) {
                    console.error(err);
                    res.json({
                        result: false,
                        err: err
                    });
                });
            }
        });


        
    } else {
        res.json({
            result: false,
            err: '参数不合法'
        });
    }
});

//获取默认版块(创建时间最早的版块)
router.get('/info/default', function(req, res, next) {
    var rs = {};
    var ent_code = req.query.ent_code;
    if(ent_code){
        var conditions={
            ent_code:ent_code
        };
        var sort = 'created'
        forumInfoService.getOneInfoByConditionsAndSort(conditions,sort,function(err,info){
            if(err){
                console.error(err);
                res.json(returnCode.BUSY);
            }else{
                rs.data = info;
                res.json(_.assign(rs, returnCode.SUCCESS));
            }
        });    
    }else{
        res.json(returnCode.BUSY);
    }
    
});



//社区报表
router.post('/infos/report', function(req, res, next) {
    // 1.获取文章的创建日期,和今天的日期,转换成日期数组
    var ent_code = req.session.user.ent_code,
        begin_time = req.body.begin_time,
        end_time = req.body.end_time,
        all_data_array = get_all_date(begin_time, end_time);

    //查询访问量最多的5条记录所用
    var conditions = {
        ent_code: ent_code,
        level: 1,
        status:{$ne:3}
    };

    var sort = '-pv_count -created';


    if (begin_time && end_time) {
        var uv_datas = [];
        var thread_datas = [];

        //统计UV
        var uv_tasks = [];
        _.forEach(all_data_array, function(d) {
            uv_tasks.push(function(cont) {
                var match = {
                    ent_code:ent_code,
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    }
                };
                var group = {
                    _id: {
                        user: '$user'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumUvLog, match, group, d, cont);
            });
        });

        //统计发帖数
        var thread_tasks = [];
        _.forEach(all_data_array, function(d) {
            thread_tasks.push(function(cont) {
                var match = {
                    ent_code:ent_code,
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    }
                };
                var group = {
                    _id: {
                        _id: '$_id'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumThread, match, group, d, cont);
            });
        });

        then.parallel([function(con) {
            //UV
            then.parallel(uv_tasks).then(function(cont, datas) {
                uv_datas = datas;
                con();
            }).fail(function(cont, err) {
                con();
            });
        }, function(con) {
            //发帖数
            then.parallel(thread_tasks).then(function(cont, datas) {
                // console.log(datas);
                thread_datas = datas;
                con();
            }).fail(function(cont, err) {
                console.log(err);
                con();
            });
        }]).then(function(cont, datas) {
            var data = {
                uv_datas: uv_datas,
                thread_datas: thread_datas
            }
            cont(null,data);
        }).then(function(cont, data) {
            //查询浏览量最高的5个帖子
            forumThreadService.getAllThreadByFid(conditions, 1, 5, sort, function(err, results) {
                if (err) {
                    console.error(err);
                    res.json(returnCode.BUSY);
                } else {
                    res.json({
                        result: true,
                        errcode: 0,
                        data: data,
                        date_array: all_data_array,
                        threads: results.items? results.items:null
                    });
                }
            });
        }).fail(function(cont, err) {
            console.error(err);
            res.json({
                result: false,
                err: err
            });
        });
    } else {
        res.json({
            result: false,
            err: '参数不合法'
        });
    }
});


//导出子板块报表
router.get('/infos/report/exportXlsReport', function(req, res, next) {
    var ent_code = req.session.user.ent_code,
        begin_time = req.query.begin_time,
        end_time = req.query.end_time,
        all_data_array = get_all_date(begin_time, end_time);

    if (begin_time && end_time) {
         var uv_datas = [];
        var thread_datas = [];

        //统计UV
        var uv_tasks = [];
        _.forEach(all_data_array, function(d) {
            uv_tasks.push(function(cont) {
                var match = {
                    ent_code:ent_code,
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    }
                };
                var group = {
                    _id: {
                        user: '$user'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumUvLog, match, group, d, cont);
            });
        });

        //统计发帖数
        var thread_tasks = [];
        _.forEach(all_data_array, function(d) {
            thread_tasks.push(function(cont) {
                var match = {
                    ent_code:ent_code,
                    created: {
                        $gte: new Date(d + ' 00:00:00'),
                        $lte: new Date(d + ' 23:59:59')
                    }
                };
                var group = {
                    _id: {
                        _id: '$_id'
                    },
                    count: {
                        $sum: 1
                    }
                };
                mapReduce(ForumThread, match, group, d, cont);
            });
        });

        then.parallel([function(con) {
            //UV
            then.parallel(uv_tasks).then(function(cont, datas) {
                uv_datas = datas;
                con();
            }).fail(function(cont, err) {
                con();
            });
        }, function(con) {
            //发帖数
            then.parallel(thread_tasks).then(function(cont, datas) {
                // console.log(datas);
                thread_datas = datas;
                con();
            }).fail(function(cont, err) {
                console.log(err);
                con();
            });
        }]).then(function(cont, datas) {
            var conf = {};
            conf.cols = [
                {caption:'日期', type:'string'},
                {caption:'访问人数', type:'number'},
                {caption:'发帖数', type:'number'}
            ];
            conf.rows = [];     
            for(var i =0;i<all_data_array.length;i+=1){
                conf.rows.push(
                    [
                        all_data_array[i],
                        uv_datas[i].count,
                        thread_datas[i].count
                    ]
                );
            }    

            var filename = '社区报表.xlsx';
            var userAgent = (req.headers['user-agent']||'').toLowerCase();

            if(userAgent.indexOf('msie') >= 0 || userAgent.indexOf('chrome') >= 0) {
                res.setHeader('Content-Disposition', 'attachment; filename=' + encodeURIComponent(filename));
            } else if(userAgent.indexOf('firefox') >= 0) {
                res.setHeader('Content-Disposition', 'attachment; filename*="utf8\'\'' + encodeURIComponent(filename)+'"');
            } else {
                /* safari等其他非主流浏览器只能自求多福了 */
                res.setHeader('Content-Disposition', 'attachment; filename=' + new Buffer(filename).toString('binary'));
            }

            var result = nodeExcel.execute(conf);
            res.setHeader('Content-Type', 'application/vnd.ms-excel;charset=utf-8');
            // res.setHeader('Content-Disposition', 'attachment; filename=InfoReport.xlsx');
            res.end(result, 'binary');
        }).fail(function(cont, err) {
            console.error(err);
            res.json({
                result: false,
                err: err
            });
        });
    } else {
        res.json({
            result: false,
            err: '参数不合法'
        });
    }
});