'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');
var mongoose = require('mongoose');
var moment = require('moment');
var async = require('async');
var then = require('thenjs');

var forumLimitOperationService = require('../../service/forumLimitOperationService');
var forumLimitOperationLogService = require('../../service/forumLimitOperationLogService');

module.exports = function(app) {
    app.use('/admin/forum', router);
};

//新增或更新论坛行为限制
router.post('/limitOperation/createOrUpdate', function(req, res, next) {
    var ent_code = req.session.user.ent_code;
    var userId = req.body.userId;
    var selects = req.body.selects;

    var limit_actions = [];

    if(selects){
        // 封装操作
        for(var i in selects){
            var begin_time = moment(new Date()).format('YYYY-MM-DD');
            var end_time = moment(new Date()).add(selects[i].days, 'days').format('YYYY-MM-DD');
            var obj = {
                limit_reason: selects[i].limit_reason,
                limit_type: selects[i].limit_type,
                begin_time: new Date(begin_time),
                end_time: new Date(end_time),
                days:selects[i].days
            }
            limit_actions.push(obj);
        }
    }
    

    //封装实体
    var forumLimiOperation = {
        ent_code: ent_code,
        userId: userId,
        limit_actions: limit_actions
    }

    async.parallel([ function(callback) {
        //创建或更新
        forumLimitOperationService.createOrUpdateLimitOperation({
            userId: userId,
            ent_code: ent_code,
            status: 1
        }, forumLimiOperation, function(err, result) {
            if (err) {
                console.error(err);
                callback(err,null);
            } else {
                callback(null,result);
            }
        });
    }, function(callback) {
        for(var i in limit_actions){
            var obj = {
                ent_code:ent_code,
                userId: userId,
                limit_reason: limit_actions[i].limit_reason,
                limit_type: limit_actions[i].limit_type,
                begin_time: limit_actions[i].begin_time,
                end_time: limit_actions[i].end_time,
                days: limit_actions[i].days,
            }
            forumLimitOperationLogService.createOperationLog(obj,function(err,doc){
                // console.log('save log');
            });     
        }
        callback();
    } ], function done(err, results) {
        if (err) {
            console.error(err);
            res.json(returnCode.BUSY);
        } else {
            var rs = {
                data: results[0]
            }
            res.json(_.assign(rs, returnCode.SUCCESS));
        }
    });
});

//根据userId获取论坛行为限制
router.get('/limitOperation/get/:userId', function(req, res, next) {
    var userId = req.params.userId;
    if (userId) {
        forumLimitOperationService.getLimitOperationByUserId(userId, function(err, forumLimitOperation) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                var rs = {};
                rs.data = forumLimitOperation;
                res.json(_.assign(rs, returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});
