'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');
var mongoose = require('mongoose');
var ForumGroup = mongoose.model('ForumGroup');
var ForumInfo = mongoose.model('ForumInfo');

var forumGroupService=require('../../service/forumGroupService');
var forumInfoService=require('../../service/forumInfoService');
var forumOptionsService=require('../../service/forumOptionsService');

var async=require('async');

module.exports = function(app) {
	app.use('/v1/forum', router);
};

//新增论坛组
router.post('/group/create', function(req, res, next) {
	var rs = {};
	req.body.ent_code=req.session.user.ent_code;
	forumGroupService.createGroup(req.body,function(err,group){
		if (err) {
			console.error(err);
			res.json(returnCode.BUSY);
		} else {
			rs.data = {'id':group._id};
			res.json(_.assign(rs, returnCode.SUCCESS));
		}
	});
});

//获取目标论坛组信息
router.get('/group/:gid/info', function(req, res, next) {
	var gid = req.params.gid || null;
	var rs = {};

	if (gid) {
		forumGroupService.getGroupById(gid,function(err,group){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				rs.data = group;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});

	} else {
		res.json(returnCode.WRONG_PARAM);
	}
});

/**
 * 获取论坛组列表
 * @param  {[type]} req   [description]
 * @param  {[type]} res   [description]
 * @param  {[type]} next) {	var        pageNo [description]
 * @return {[type]}       [description]
 */
router.get('/group/list', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var conditions={
    	ent_code:req.session.user.ent_code
    };
	forumGroupService.getAll(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});


/**
 * 获取板块列表
 * @param  {[type]} req   [description]
 * @param  {[type]} res   [description]
 * @param  {[type]} next) {	var        pageNo [description]
 * @return {[type]}       [description]
 */
router.get('/group/:gid/forumInfos', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var gid=req.params.gid;

	if(gid){
		forumInfoService.getAllByGid(req.session.user.ent_code,gid,pageNo,pageSize,function(err,results){
			if(err){
				console.error(err);
				res.json(returnCode.BUSY);
			}else{
				res.json(_.assign(results, returnCode.SUCCESS));
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

/**
 * 获取板块列表及轮播图
 * @param  {[type]} req   [description]
 * @param  {[type]} res   [description]
 * @param  {[type]} next) {	var        pageNo [description]
 * @return {[type]}       [description]
 */
router.get('/group/:gid/forumInfosAndShuffling', function(req, res, next) {
	async.parallel([
			function(callback){
				var pageNo = req.query.pageNo || 1;
			    var pageSize = req.query.pageSize || 10;
			    var gid=req.params.gid;

				if(gid){
					forumInfoService.getAll(req.session.user.ent_code,gid,pageNo,pageSize,function(err,results){
						if(err){
							console.error(err);
							callback(err,null);
						}else{
							callback(null,results);
						}
					});
				}else{
					callback('not find gid',null);
				}
			},
			function(callback){
				forumOptionsService.getShuffling(req.session.user.ent_code,callback);
			}
		],function(err,results){
			if(err){
				res.json(returnCode.BUSY);
			}else{
				var infos=results[0];
				var shuffling=results[1];
				var rs={};
				rs.infos=infos;
				rs.shuffling=shuffling;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
	});
});