'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');

var mongoose = require('mongoose');
//var forumThreadService = require('../../service/forumThreadService');
var forumShareConfigService = require('../../service/forumShareConfigService');
//var forumShareService = require('../../service/forumShareService');
//var config = require('../../../config/config');
var then = require('thenjs');

module.exports = function(app) {
    app.use('/v1/forum', router);
};

//type:类型（板块，照片墙等）; key:类型里面的标题（title，desc等）；value:值
function getForumConfig(key, value, ent_code) {
    var forumConfig = {};
    forumConfig.meta_key = key;
    forumConfig.meta_value = value;
    forumConfig.ent_code = ent_code;
    return forumConfig;
}

//批量创建默认分享设置
router.post('/forumConfig/put', function(req, res, next) {
    var model = req.body;
    var ent_code = req.session.user.ent_code;
    model.ent_code = ent_code;
    if (model.ent_code) {
        forumShareConfigService.create(model, function(err, result) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(_.assign(result, returnCode.SUCCESS));
            }
        });

    } else {
        res.json(returnCode.BUSY);
    }

});

//初始化默认分享数据
router.get('/forumConfig/getConfig', function(req, res, next) {
    var ent_code = req.session.user.ent_code;
    forumShareConfigService.getByKey(ent_code, req.query.meta_key, function(err, result) {
        if (err) {
            console.error(err);
            res.json(returnCode.BUSY);
        } else {
            res.json({message:'success',data:result});
        }

    });
});
