'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');

var mongoose = require('mongoose');
var forumUserService=require('../../service/forumUserService');

var async=require('async');

var user=require('../../utils/user');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//更新管理员信息
router.post('/user/updateByUid', function(req, res, next) {
	var uid = req.body.uid;
	var ent_code = req.session.user.ent_code;
	var nickName = req.body.nickName;
	var icon = req.body.pic;
	if(uid && ent_code){
		var entity = {};
		if(nickName){
			entity.nickName = nickName;
		}
		if(icon){
			if (icon && icon.indexOf('http://') == -1) {
		        if (process.env.NODE_ENV === 'production') {
		            icon = 'http://fs.wxpai.cn/' + icon;
		        } else {
		            icon = 'http://dev.fs.wxpai.cn/' + icon;
		        }
		    }
		    entity.icon = icon;
		}

		forumUserService.updateUserByUIdAndEntCode(uid,ent_code,entity,function(err,result){
			if(err){
				res.json(returnCode.BUSY);
			}else{
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});