'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash'),
    thenjs = require('thenjs');
var mongoose = require('mongoose');
var ForumModeratorApply = mongoose.model('ForumModeratorApply');
var user = require('../../utils/user');
var ForumThread = mongoose.model('ForumThread');
var ForumModerator = mongoose.model('ForumModerator');
var forumThreadService = require('../../service/forumThreadService');
var forumLimitOperationService = require('../../service/forumLimitOperationService');
var forumModeratorApplyService = require('../../service/forumModeratorApplyService');
var forumAboutMEService=require('../../service/forumAboutMEService');
var httpService = require('../../service/httpService');
var request=require('request');
var env = process.env.NODE_ENV;
var API_ADDRESS='http://localhost:8080';
if(env == 'sandbox'){
	API_ADDRESS='http://rest.wxpai.cn';
}else if(env == 'production'){
	API_ADDRESS='https://rest.wxpai.cn';
}

module.exports = function(app) {
    app.use('/v1/forum', router);
};

function moderatorOperateLog(forumUser,thread,type){
	var ent_code= thread.ent_code;
	var forumModerator = new ForumModerator({
		ent_code:ent_code,
		info:thread.info,
		userName:thread.from.nickName || thread.from.displayName,
		content:{id:thread._id,content:thread.content},
		behavior:type,
		moderatorName:forumUser.nickName || forumUser.displayName
	});
	forumModerator.save(function(err, res) {});
}

function addIntegral(thread){
	var openID=thread.from.uid;
	var tid= thread._id;
	var ent_code= thread.ent_code;
	forumLimitOperationService.checkLimitOperationProhibitionAddIntegral(tid, function(err, flag){
		if(!err && !flag){
			//获取mid
			console.log(API_ADDRESS);
			request.get({url:API_ADDRESS+'/v1.0/internal/member/getMidbyOpenID?entCode='
				+ent_code+'&openID='+openID,json:true},function(e,r,res){
				console.log(res);
			 	if(res && res.data){
			 		httpService.sendRequest(ent_code,res.data,'thread_recomment');
			 	}	
			});
		}
	});
}
//获取版主为当前用户的板块id数组
router.get('/moderators/plates', function(req, res, next) {
	var entCode = req.session.user.ent_code;
	var id = user.getMobileUser(req);
	var q = {};
	q.status=1;
	q.ent_code = entCode;
	q.forumUser=id;
	ForumModeratorApply.findOne(q).exec(function(err,result){
		if(err){
			return res.json(returnCode.BUSY);
		}
		var items = [];
		if(result && result.infoIds){
			items = result.infoIds;
		}
		res.setHeader('Cache-Control', 'public, max-age=3600'); // 公共缓存一个小时
        res.setHeader('Expires', new Date(Date.now() + 3600000).toUTCString());
		res.json(_.assign({items:items}, returnCode.SUCCESS));
	});
});

//版主加精
//1.判断这篇文章是不是后台发的，后台发的不允许操作
//2.判断当前用户是不是这个文章对应板块的版主
router.get('/moderators/recommend/:tid', function(req, res, next) {
	var tid = req.params.tid,
        entCode = req.session.user.ent_code,
		id = user.getMobileUser(req);//user._id	
	var q1={};//拼装查询条件
	q1.ent_code = entCode;
	q1._id=tid;
	q1.status=1;
	q1.$or=[{
		recommend: 0
	}, {
		recommend: null
	}];
	ForumThread.findOne(q1).populate('from').exec(function(err, t) {
        if (err || !t) {
            return res.json(returnCode.BUSY);
        }
		if(t.from && !isNaN(t.from.uid)){//是后台发的,没有权限操作
			return res.json(returnCode.ACTION_NOT_PERMISSION);
		}
		if(!t.info){//没有板块id直接返回
			return res.json(returnCode.BUSY);
		}
		var q2 = {};//查询当前用户是不是这篇文章的版主
		q2.status=1;
		q2.ent_code = entCode;
		q2.forumUser=id;
		q2.infoIds={$all:[t.info]};
		ForumModeratorApply.findOne(q2).populate('forumUser').exec(function(err,result){
			if(err){
				return res.json(returnCode.BUSY);
			}
			if(!result){//不是该版主
				return res.json(returnCode.ACTION_NOT_PERMISSION);
			}
			//加精
			forumThreadService.updateRecommendByThreadId(tid, function(err) {
				if (err) {
					res.json(returnCode.BUSY);
				} else {
					res.json(returnCode.SUCCESS);
					moderatorOperateLog(result.forumUser,t,1);
					addIntegral(t);//根据openid 送积分
				}
			});
		});
    });
});
//版主取消加精
router.get('/moderators/unrecommend/:tid', function(req, res, next) {
	var tid = req.params.tid,
        entCode = req.session.user.ent_code,
		id = user.getMobileUser(req);//user._id
		
	var q1={};//拼装查询条件
	q1.ent_code = entCode;
	q1._id=tid;
	q1.status=1;
	q1.recommend=1;
	ForumThread.findOne(q1).populate('from').exec(function(err, t) {
        if (err || !t) {
            return res.json(returnCode.BUSY);
        }
		if(t.from && !isNaN(t.from.uid)){//是后台发的,没有权限操作
			return res.json(returnCode.ACTION_NOT_PERMISSION);
		}
		if(!t.info){//没有板块id直接返回
			return res.json(returnCode.BUSY);
		}
		var q2 = {};//查询当前用户是不是这篇文章的版主
		q2.status=1;
		q2.ent_code = entCode;
		q2.forumUser=id;
		q2.infoIds={$all:[t.info]};
		ForumModeratorApply.findOne(q2).populate('forumUser').exec(function(err,result){
			if(err){
				return res.json(returnCode.BUSY);
			}
			if(!result){//不是该版主
				return res.json(returnCode.ACTION_NOT_PERMISSION);
			}
			//取消加精
			forumThreadService.updateUnRecommendByThreadId(tid, function(err) {
				if (err) {
					console.error(err);
					res.json(returnCode.BUSY);
				} else {
					res.json(returnCode.SUCCESS);
					moderatorOperateLog(result.forumUser,t,2);
				}
			});
		});
    });
});

//版主删除帖子
router.get('/moderators/delthread/:tid', function(req, res, next) {
	var tid = req.params.tid,
        entCode = req.session.user.ent_code,
		id = user.getMobileUser(req);//user._id
	var q1={};//拼装查询条件
	q1.ent_code = entCode;
	q1._id=tid;
	q1.status=1;
	ForumThread.findOne(q1).populate('from').exec(function(err, t) {
        if (err || !t) {
            return res.json(returnCode.BUSY);
        }
		if(t.from && !isNaN(t.from.uid)){//是后台发的,没有权限操作
			return res.json(returnCode.ACTION_NOT_PERMISSION);
		}
		if(!t.info){//没有板块id直接返回
			return res.json(returnCode.BUSY);
		}
		var q2 = {};//查询当前用户是不是这篇文章的版主
		q2.status=1;
		q2.ent_code = entCode;
		q2.forumUser=id;
		q2.infoIds={$all:[t.info]};
		ForumModeratorApply.findOne(q2).populate('forumUser').exec(function(err,result){
			if(err){
				return res.json(returnCode.BUSY);
			}
			if(!result){//不是该版主
				return res.json(returnCode.ACTION_NOT_PERMISSION);
			}
			//删除帖子
			forumThreadService.logicDeleteThreadById(tid, function(err) {
				if (err) {
					console.error(err);
					res.json(returnCode.BUSY);
				} else {
					res.json(returnCode.SUCCESS);
					moderatorOperateLog(result.forumUser,t,3);
					forumAboutMEService.updateThreadStatus(tid,3);
				}
			});
		});
    });
});

//添加版主申请
router.post('/forumModeratorApply/create', function(req, res, next) {
    var ent_code = req.session.user.ent_code;
    var fuserId = req.session.mobileForumUser.userId;
    var applyMsg = req.body.applyMsg;
    if (fuserId && applyMsg) {
    	forumModeratorApplyService.getForumModeratorApplyByFUserId(fuserId,function(err, doc){
    		if(err){
    			console.error(err);
                res.json(returnCode.BUSY);
    		}else if(doc){ //已申请
    			res.json({
					errorcode: 0,
					errormsg: '已申请,请勿重复申请!'
				});
    		}else{
    			var conditions = {
		            ent_code: ent_code,
		            forumUser: fuserId
		        }
		        var model = {
		            ent_code: ent_code,
		            forumUser: fuserId,
		            applyMsg: applyMsg
		        };
		        forumModeratorApplyService.createOrUpdateLimitOperation(conditions, model, function(err, ModeratorApply) {
		            if (err) {
		                console.error(err);
		                res.json(returnCode.BUSY);
		            } else {
		                res.json(_.assign(returnCode.SUCCESS));
		            }
		        });
    		}
    	})
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

