'use strict';
var mongoose = require('mongoose');
var ForumThread = mongoose.model('ForumThread');
var ForumComment = mongoose.model('ForumComment');
var ForumAboutMe = mongoose.model('ForumAboutMe');
var THREAD_TYPE=1;
var COMMENTLEVEL1_TYPE=2;
var COMMENTLEVEL2_TYPE=3;
var forumCommentService = require('./forumCommentService');
var forumThreadService = require('./forumThreadService');

var then = require('thenjs');
var _ = require('lodash');
var async = require('async');

/**ʼº۵ҵ**/
function canImportThreadToAboutme(tid,callback){
	ForumAboutMe.findOne({
        thread:tid,
		type:THREAD_TYPE
    }, function(err, result) {
        if (err) {//дֱӺԴ
            callback(null, false);
        } else {
            callback(null, !result);
        }
    });
}

function canImportCommentLevel1ToAboutme(cid,callback){
	ForumAboutMe.findOne({
        commentLevel1:cid,
		type:COMMENTLEVEL1_TYPE
    }, function(err, result) {
        if (err) {//дֱӺԴ
            callback(null, false);
        } else {
            callback(null, !result);
        }
    });
}

function canImportCommentLevel2ToAboutme(cid,callback){
	ForumAboutMe.findOne({
        commentLevel2:cid,
		type:COMMENTLEVEL2_TYPE
    }, function(err, result) {
        if (err) {//дֱӺԴ
            callback(null, false);
        } else {
            callback(null, !result);
        }
    });
}

function saveThread(thread){
	var forumAboutMe=new ForumAboutMe({
		ent_code:thread.ent_code,
		from:thread.from,
		type:THREAD_TYPE,
		thread:thread._id,
		threadStatus:thread.status,
		created:thread.created || new Date()
	});
	forumAboutMe.save(function(err){
		if(err){
			console.log(err);
		}
	});
}

function saveCommentLevel1(thread,commentLevel1){
	var forumAboutMe=new ForumAboutMe({
		ent_code:commentLevel1.ent_code,
		from:commentLevel1.from,
		to:thread.from,
		type:COMMENTLEVEL1_TYPE,
		thread:thread._id,
		threadStatus:thread.status,
		commentLevel1:commentLevel1._id,
		commentLevel1Status:commentLevel1.status,
		created:commentLevel1.created || new Date()
	});
	forumAboutMe.save(function(err){
		if(err){
			console.log(err);
		}
	});
};

function saveCommentLevel2(thread,commentLevel1,commentLevel2){
	var forumAboutMe=new ForumAboutMe({
		ent_code:commentLevel2.ent_code,
		from:commentLevel2.from,
		to:commentLevel2.to,
		type:COMMENTLEVEL2_TYPE,
		thread:thread._id,
		threadStatus:thread.status,
		commentLevel1:commentLevel1._id,
		commentLevel1From:commentLevel1.from,
		commentLevel1Status:commentLevel1.status,
		commentLevel2:commentLevel2._id,
		commentLevel2ThreadFrom:thread.from,
		commentLevel2Status:commentLevel2.status,
		created:commentLevel2.created || new Date()
	});
	forumAboutMe.save(function(err){
		if(err){
			console.log(err);
		}
	});
};

function FetchCommentToAboutMeByPage(pageNo,pageSize,count,condition,callback){
	var skip = (pageNo - 1) * pageSize;
	var limit = count - skip > pageSize ? pageSize : (count - skip);
	ForumComment.find(condition).skip(skip).limit(limit).select('_id ent_code from to thread comments status created').populate({
		path:'thread',
		select:'_id ent_code from status created'
	}).exec(function(err, commentLevel1s) {
		if(commentLevel1s && commentLevel1s.length>0){
			_.forEach(commentLevel1s,function(commentLevel1){
				canImportCommentLevel1ToAboutme(commentLevel1._id,function(err,result){
						if(result){
							saveCommentLevel1(commentLevel1.thread || {},commentLevel1);
							//
							if(commentLevel1.comments && commentLevel1.comments.length>0){
								commentLevel1.comments.forEach(function(commentLevel2_id){
									canImportCommentLevel2ToAboutme(commentLevel2_id,function(err,result){
										if(result){
											ForumComment.findOne({_id: commentLevel2_id}).select('_id ent_code from to status created').exec(function(err,commentLevel2){
												if(commentLevel2){
													saveCommentLevel2(commentLevel1.thread||{},commentLevel1,commentLevel2);
												}									
											});
										}
									});
								});
							}
						}
					});
			});
		}
		setTimeout(callback,1000);
	});
}

function FetchThreadToAboutMeByPage(pageNo,pageSize,count,condition,callback){
	var skip = (pageNo - 1) * pageSize;
	var limit = count - skip > pageSize ? pageSize : (count - skip);
	ForumThread.find(condition).skip(skip).limit(limit).select('_id ent_code from status created').exec(function(err, threads) {
		if(threads && threads.length>0){
			_.forEach(threads,function(thread){
				canImportThreadToAboutme(thread._id,function(err,result){
					result && saveThread(thread);
				})
			});
		}
		setTimeout(callback,1000);
	});
}

exports.FetchThreadToAboutMe=function(){
	var pageSize = 50;
	var tasks = [];
	var condition={};
	ForumThread.find(condition).count(function(err,count){
		if(count){
			_.forEach(_.range((count / pageSize) + 1),function(o,pageNO){
				tasks.push(function(cb){
					FetchThreadToAboutMeByPage(pageNO,pageSize,count,condition,cb);
				});
			});
			async.series(tasks,function(err, result) {
			});
		}
		
	});
};

exports.FetchCommentToAboutMe=function(){
	var pageSize = 50;
	var tasks = [];
	var condition={level:1};
	ForumComment.find(condition).count(function(err,count){
		if(count){
			_.forEach(_.range((count / pageSize) + 1),function(o,pageNO){
				tasks.push(function(cb){
					FetchCommentToAboutMeByPage(pageNO,pageSize,count,condition,cb);
				});
			});
			async.series(tasks,function(err, result) {
			});
		}
	});
};
/**º۵ҵ**/


exports.saveThread=function(thread){
	var forumAboutMe=new ForumAboutMe({
		ent_code:thread.ent_code,
		from:thread.from,
		type:THREAD_TYPE,
		thread:thread._id,
		threadStatus:thread.status,
		created:new Date()
	});
	forumAboutMe.save(function(err){
		if(err){
			console.log(err);
		}
	});
};

exports.saveCommentLevel1=function(thread,commentLevel1){
	var forumAboutMe=new ForumAboutMe({
		ent_code:thread.ent_code,
		from:commentLevel1.from,
		to:thread.from,
		type:COMMENTLEVEL1_TYPE,
		thread:thread._id,
		threadStatus:thread.status,
		commentLevel1:commentLevel1._id,
		commentLevel1Status:commentLevel1.status,
		created:new Date()
	});
	forumAboutMe.save(function(err){
		if(err){
			console.log(err);
		}
	});
};

exports.saveCommentLevel2=function(tid,commentLevel1,commentLevel2){
	forumThreadService.getById(tid,function(err,thread){
		var forumAboutMe=new ForumAboutMe({
			ent_code:commentLevel2.ent_code,
			from:commentLevel2.from,
			to:commentLevel2.to,
			type:COMMENTLEVEL2_TYPE,
			thread:thread._id,
			threadStatus:thread.status,
			commentLevel1:commentLevel1._id,
			commentLevel1From:commentLevel1.from,
			commentLevel1Status:commentLevel1.status,
			commentLevel2:commentLevel2._id,
			commentLevel2ThreadFrom:thread.from,
			commentLevel2Status:commentLevel2.status,
			created:new Date()
		});
		forumAboutMe.save(function(err){
			if(err){
				console.log(err);
			}
		});
	});
};

exports.saveCommentLevel2BySearch=function(tid,l1id,l2id){
	forumThreadService.getById(tid,function(err,thread){
		if(err || !thread){
			return console.log(err || 'ûжӦthread');
		}
		forumCommentService.getCommentById(l1id,function(err,commentLevel1){
			if(err || !commentLevel1){
				return console.log(err || 'ûжӦһ');
			}
			forumCommentService.getCommentById(l2id,function(err,commentLevel2){
				if(err || !commentLevel2){
					return console.log(err || 'ûжӦĶ');
				}
				var forumAboutMe=new ForumAboutMe({
					ent_code:commentLevel2.ent_code,
					from:commentLevel2.from,
					to:commentLevel2.to,
					type:COMMENTLEVEL2_TYPE,
					thread:thread._id,
					threadStatus:thread.status,
					commentLevel1:commentLevel1._id,
					commentLevel1From:commentLevel1.from,
					commentLevel1Status:commentLevel1.status,
					commentLevel2:commentLevel2._id,
					commentLevel2ThreadFrom:thread.from,
					commentLevel2Status:commentLevel2.status,
					created:new Date()
				});
				forumAboutMe.save(function(err){
					if(err){
						console.log(err);
					}
				});
			});
		});
	});
};

exports.updateThreadStatus=function(tid,status){
	var condition={
		type:THREAD_TYPE,
		thread:new mongoose.Types.ObjectId(tid),
		threadStatus:{$ne:status}
	}
	var obj={threadStatus:status};
	ForumAboutMe.find(condition,function(err,docs){
		if(err){
			return console.log(err);
		}
		if(!docs || !docs.length){
			return false;
		}
		docs.forEach(function(doc){
			ForumAboutMe.findOneAndUpdate({_id:doc._id},obj,function(err){
				if(err){
					console.log(err);
				}
			});
		});
	});
};

exports.updateCommentLevel1Status=function(cid,status){
	var condition={
		type:COMMENTLEVEL1_TYPE,
		commentLevel1:new mongoose.Types.ObjectId(cid),
		commentLevel1Status:{$ne:status}
	}
	var obj={commentLevel1Status:status};
	ForumAboutMe.find(condition,function(err,docs){
		if(err){
			return console.log(err);
		}
		if(!docs || !docs.length){
			return false;
		}
		docs.forEach(function(doc){
			ForumAboutMe.findOneAndUpdate({_id:doc._id},obj,function(err){
				if(err){
					console.log(err);
				}
			});
		});
	});
};

exports.updateCommentLevel2Status=function(cid,status){
	var condition={
		type:COMMENTLEVEL2_TYPE,
		commentLevel2:new mongoose.Types.ObjectId(cid),
		commentLevel2Status:{$ne:status}
	}
	var obj={commentLevel2Status:status};
	ForumAboutMe.find(condition,function(err,docs){
		if(err){
			return console.log(err);
		}
		if(!docs || !docs.length){
			return false;
		}
		docs.forEach(function(doc){
			ForumAboutMe.findOneAndUpdate({_id:doc._id},obj,function(err){
				if(err){
					console.log(err);
				}
			});
		});
	});
};

exports.me2other=function(ent_code,id,pageNo,pageSize,callback){
	var condition={
		ent_code:ent_code,
		from:new mongoose.Types.ObjectId(id),
		$or:[{
			type:THREAD_TYPE,threadStatus:1
		},{
			type:COMMENTLEVEL1_TYPE,threadStatus:1,commentLevel1Status:1
		},{
			type:COMMENTLEVEL2_TYPE,threadStatus:1,commentLevel1Status:1,commentLevel2Status:1
		}]
	};

	ForumAboutMe.find(condition).count(function(err,count){
		if(err){
			return callback && callback(err);
		}
		var obj = {};
		obj.total = count || 0;
		obj.pageNo = pageNo;
		obj.pageSize = pageSize;
		obj.items = [];
		if(!count){
			return callback && callback(null,obj);
		}
		var skip = (pageNo - 1) * pageSize;
		var limit = count - skip > pageSize ? pageSize : (count - skip);
		var sortBy = '-created';
		ForumAboutMe.find(condition).populate({
			path: 'from to commentLevel1From commentLevel2ThreadFrom',
			select: 'uid  nickName icon displayName displayIcon classLevel'
		}).populate({
			path: 'thread',
			select: '-title -topTime -tag_topTime -tag -comments -created'
		}).populate({
			path: 'commentLevel1 commentLevel2',
			select: 'content comment_count praise_count status floor'
		}).limit(limit).skip(skip).sort(sortBy).exec(function(err, docs) {
			if(err){
				return callback && callback(err);
			}
			obj.items = docs || [];
			return callback && callback(null,obj);
		});
	});
};

exports.other2me=function(ent_code,id,pageNo,pageSize,callback){
	var condition={
		ent_code:ent_code,
		to:new mongoose.Types.ObjectId(id),
		$or:[{
			type:COMMENTLEVEL1_TYPE,threadStatus:1,commentLevel1Status:1
		},{
			type:COMMENTLEVEL2_TYPE,threadStatus:1,commentLevel1Status:1,commentLevel2Status:1
		}]
	};
	ForumAboutMe.find(condition).count(function(err,count){
		if(err){
			return callback && callback(err);
		}
		var obj = {};
		obj.total = count || 0;
		obj.pageNo = pageNo;
		obj.pageSize = pageSize;
		obj.items = [];
		if(!count){
			return callback && callback(null,obj);
		}
		var skip = (pageNo - 1) * pageSize;
		var limit = count - skip > pageSize ? pageSize : (count - skip);
		var sortBy = '-created';
		ForumAboutMe.find(condition).populate({
			path: 'from to commentLevel1From commentLevel2ThreadFrom',
			select: 'uid  nickName icon displayName displayIcon classLevel'
		}).populate({
			path: 'thread',
			select: '-title -topTime -tag_topTime -tag -comments -created'
		}).populate({
			path: 'commentLevel1 commentLevel2',
			select: 'content comment_count praise_count status floor'
		}).limit(limit).skip(skip).sort(sortBy).exec(function(err, docs) {
			if(err){
				return callback && callback(err);
			}
			obj.items = docs || [];
			return callback && callback(null,obj);
		});
	});
};