'use strict';
var mongoose = require('mongoose');
var BlackList = mongoose.model('BlackList');
var ForumUserService = require("./forumUserService");
var ForumUser = mongoose.model('ForumUser');
var async=require('async');


exports.getBlackPageList=function(condition,pageNo,pageSize,callback){
	var _condition = condition || {};
	var pageNo = Number(pageNo) || 1;
	var pageSize = pageSize || 10;
	var obj={};
		obj.total=0;
		obj.pageNo=pageNo;
		obj.pageSize=pageSize;
		obj.items=[];
	var search = function(count){
		var skip = (pageNo - 1) * pageSize;
		skip = skip >0 ? skip :0;
		var limit = pageSize;
		BlackList.find(_condition)
		.populate('blackUser').limit(limit)
		.skip(skip).sort('-created').exec(function(err,blackUsers){
			if(err){
				console.error(err);
				return callback && callback(err,null);
			}
			obj.total=count;
			obj.pageNo=pageNo;
			obj.pageSize=pageSize;
			obj.items=blackUsers;
			return callback && callback(null,obj);
		});
	};
	BlackList.count(_condition, function (err, count) {
		   if(err){
				return callback && callback(err,null);
		   }
		   if(!!!count){
		   		return callback && callback(null,obj);
		   }
		   return search(count);
	});
};

exports.addBlack = function(blackList,entcode,callback){
	if(!!!blackList || 
			(!!!blackList.blackOpenId && !!!blackList.uid)){
		return callback && callback('bad args');
	}
	blackList.ent_code = entcode;
	async.waterfall([function(cb){//判断是否存在openid
		var condition = {ent_code:entcode};
		if(blackList.blackOpenId){
			condition.blackOpenId = blackList.blackOpenId;
			BlackList.count(condition,function(err,count){
				if(count && count>0){
					console.log(condition);
					return callback && callback('已经存在的记录');
				}
				cb();
			});
		}else{
			cb();
		}
	},function(cb){//判断是否存在uid
		var condition = {ent_code:entcode};
		if(blackList.uid){
			condition.blackUser = blackList.uid;
			BlackList.count(condition,function(err,count){
				if(count && count>0){
					console.log(condition);
					return callback && callback('已经存在的记录');
				}
				cb();
			});
		}else{
			cb();
		}
	},function(cb) {
		var uid =blackList.uid;
		delete blackList.uid;
		if(!!!uid){
			return cb();
		}
        ForumUserService.getUserById(uid,
	    	function(err,result){
	    		if(!!!err && result){
	    			blackList.blackUser = result;
	    		}
	    		cb();
	    });
	},
	function(n, cb) {
		var _blackList= new BlackList(blackList);
		_blackList.save(function(err, black) {
			if(err){
				console.error(err);
				return callback && callback(err);
			}
			return callback && callback(null,{_id:black._id});
		});
	}],
	function(err, result) {
	     return callback && callback(err);
	});	
};


exports.addBlacks = function(blacks,entcode,callback){
	if(!!!blacks || 
			!!!blacks.length){
		return callback && callback('bad args');
	}
	var asyncTasks = [];
	blacks.forEach(function(black){
		asyncTasks.push(function(callback) {
		       exports.addBlack(black,entcode,function(err,result){
				    callback(null, !!err ? {err:err} : result);
		       });
		});
	});

	async.parallel(asyncTasks, function(err, results) {
		if (err || !!!results || !!!results.length) {
			return callback && callback(err || "操作失败！");
		}
		var sucs = [];
		var errs = [];
		results.forEach(function(result){
			if(result){
				if(result.err){
					errs.push(result.err);	
				}else{
					sucs.push(result);
				}
			}
		});
		return callback && callback(null,{sucs:sucs,errs:errs});
	});
};

exports.getBlackById = function(id,callback){
	BlackList.findById(id).populate('blackUser').exec(function(err, black) {
		if (err) {
			return callback && callback(err,null);
		} 
		return callback && callback(null,black);
	});
};
//根据ID更新黑名单
exports.updateBlackById=function(id,entity,callback){
	if(!!!id ||!!!entity){
		return callback && callback('bad args');
	}
	async.waterfall([function(cb) {
		var uid =entity.uid;
		delete entity.uid;
		delete entity.blackUser;
		if(!!!uid){
			return cb();
		}
        ForumUserService.getUserById(uid,
	    	function(err,result){
	    		if(!!!err && result){
	    			entity.blackUser = result._id;
	    		}
	    		cb();
	    });
	},
	function(n, cb) {
		BlackList.update({ _id: id}, entity,null,function(err,result){
		if (err) {
			console.error(err);
			return callback && callback(err,null);
		} 
		return callback && callback(null,result);
	});
	}],
	function(err, result) {
	     return callback && callback(err);
	});	
	
};

exports.removeBlackById = function(id,callback){
	BlackList.remove({ _id: id},function(err,result){
		if (err) {
			return callback && callback(err,null);
		} 
		return callback && callback(null,result);
	});
};

exports.getNotBlackUsers=function(entcode,pageNo,pageSize,callback){
	var pageNo = pageNo || 1;
	var pageSize = pageSize || 10;
	var getPageList = function(count,nins){
		var skip = (pageNo - 1) * pageSize;
        var limit = count - skip > pageSize ? pageSize : (count - skip);
		ForumUser.find({ent_code:entcode,_id:{$nin:nins}}).limit(limit).skip(skip)
		.exec(function(err,results){
			if(err){
				callback(err,null);
			}else{
				if(results){
					callback(null,{total:count,items:results});
				}else{
					callback(null,{total:count,items:[]});
				}
			}
		});
	};
	async.waterfall([function(cb){
		//获取黑名单
		BlackList.find({ent_code:entcode})
		.select('blackUser').exec(function(err,results){
			var nins=[];
			if(results && results.length > 0){
				for(var i=0,len=results.length;i<len;i++){
					if(results[i].blackUser){
						nins.push(results[i].blackUser);
					}
				}
			}
			cb(null,nins);
		});
	},
	function(n, cb) {
		console.log(n);
		ForumUser.count({ent_code:entcode,_id:{$nin:n}}).exec(function(err,count){
			if(err){
				callback(err,null);
			}else{
				if(count > 0){
					getPageList(count,n);
				}else{
					callback(null,{total:0,items:[]});
				}
			}
		});
	}],
	function(err, result) {
	     return callback && callback(err);
	});	
};