'use strict';
var mongoose = require('mongoose');
var ForumFavorite = mongoose.model('ForumFavorite');

//创建收藏
exports.createFavorite=function(entity,callback){
	var forum = new ForumFavorite(entity);
	forum.save(function(err, forum) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,forum);
		}
	});
};

//根据ID删除文章
exports.deleteFavoriteById=function(tid,callback){
	ForumFavorite.remove({ _id: tid},function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//获取数量
function countAll(ent_code,user,callback) {
	ForumFavorite.count({ent_code:ent_code,user:user}, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//获取全部列表数据
exports.getAll= function(ent_code,user,pageNo,pageSize,callback) {
	countAll(ent_code,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);
		    ForumFavorite.find({ent_code:ent_code,user:user}, null, {skip: skip,limit:limit},function(err,docs){
				if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;
					callback(null,obj);
				}
			});
		}
	});
};

