'use strict';
var mongoose = require('mongoose');
var ForumInfo = mongoose.model('ForumInfo');

//创建论坛板块
exports.createInfo=function(entity,callback){
	var forum = new ForumInfo(entity);
	forum.save(function(err, forum) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,forum);
		}
	});
};

//根据ID获取论坛板块
exports.getInfoById=function(fid,callback){
	ForumInfo.findById(fid, function(err, thread) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,thread);
		}
	});
};

//根据ID更新论坛板块
exports.updateInfoById=function(fid,entity,callback){
	ForumInfo.update({ _id: fid}, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//根据ID更新论坛组
exports.deleteInfoById=function(fid,callback){
	ForumInfo.remove({ _id: fid},function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//获取数量
function countAllByGid(conditions,callback) {
	ForumInfo.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//获取全部列表数据
exports.getAllByGid= function(conditions,pageNo,pageSize,callback) {
	countAllByGid(conditions,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);
		    ForumInfo.find(conditions).populate('group').skip(skip).limit(limit).sort({order_idx:-1}).exec(function(err, docs) {
		    	if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;
					callback(null,obj);
				}
		    });
		}
	});
};

exports.getAllOrderIDX=function(conditions,callback){
	ForumInfo.find(conditions).select('_id order_idx').sort({order_idx:-1}).exec(function(err, docs) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,docs);
		}
	});
};
//更新板块浏览数
exports.updateInfoPvCount=function(fid,callback){
	ForumInfo.update(
			{_id:fid}, 
			{$inc: { pv_count: 1 }},
			{w:1,safe:true},
			function(err,result){
				if(err){
					console.error(err);
					callback(err,null);
				}else{
					callback(null,null);
				}
			});
};

//上移
exports.updateInfoIdx=function(fid,idx,callback){
	ForumInfo.update(
	{_id:fid},
	{ order_idx: idx },
	null,
	function(err,result){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			callback(null,true);
		}
	});
};

//获取板块
//获取全部列表数据
exports.getOneInfoByConditionsAndSort= function(conditions,sort,callback) {
	ForumInfo.findOne(conditions).sort(sort).exec(function(err, doc) {
    	if (err || !doc) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,doc);
		}
    });
};