'use strict';
var mongoose = require('mongoose');
var forumModeratorApply = mongoose.model('ForumModeratorApply');

//添加
function create(entity, callback) {
    var model = new forumModeratorApply(entity);
    model.save(function(err, result) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, result);
        }
    });
}

//获取数量
function count(conditions, callback) {
    forumModeratorApply.count(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, count);
        }
    });
}

//创建或更新论坛行为限制
exports.createOrUpdateLimitOperation = function(conditions, entity, callback) {

	forumModeratorApply.findOneAndUpdate(conditions, entity, function(err, doc) {
        if (err) {
        	console.log(err);
            callback(err, null);
        } else {
            if(!doc){
            	create(entity,function(err, result){
	        		if(err){
	        			console.error(err);
	            		callback(err, null);
	        		}else{
						callback(null, result);
	        		}
	        	});
            }else{
            	callback(null,doc);
            }
        }
    });
};

//获取fuserId获取
exports.getForumModeratorApplyByFUserId = function(fuserId, callback) {
    forumModeratorApply.findOne({
        forumUser: fuserId
    }, function(err, doc) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, doc);
        }
    });
};


//获取fuserId获取
exports.deleteForumModeratorApplyById = function(id, callback) {
    forumModeratorApply.remove({
        _id: id
    }, function(err) {
        if (err) {
            console.error(err);
            callback(err);
        } else {
            callback(null);
        }
    });
};



//分页获取列表数据
exports.getForumModeratorApplys = function(conditions, pageNo, pageSize, sort, callback) {
    count(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            var skip = (pageNo - 1) * pageSize;
            var limit = count - skip > pageSize ? pageSize : (count - skip);
            var sortBy = '-created';
            if (sort) {
                sortBy = sort;
            }
            forumModeratorApply.find(conditions).populate('forumUser').populate('infoIds').limit(limit).skip(skip).sort(sortBy).exec(function(err, docs) {
                if (err) {
                    console.error(err);
                    callback(err, null);
                } else {
                    var obj = {};
                    obj.total = count;
                    obj.pageNo = pageNo;
                    obj.pageSize = pageSize;
                    obj.items = docs;
                    callback(null, obj);
                }
            });
        }
    });
};


