'use strict';
var mongoose = require('mongoose');
var ForumModerator=mongoose.model('ForumModerator');
var ForumThread = mongoose.model('ForumThread');
var ForumComment = mongoose.model('ForumComment');
var ForumShare = mongoose.model('ForumShare');

var forumUserService = require('./forumUserService');
var forumCommentService = require('./forumCommentService');

var async = require('async');
var then = require('thenjs');

exports.getAllOperationByFidAndNickName = function(userName, conditions, pageNo, pageSize, sort, callback) {
    getAllOperationByFidHelpAndNickName(userName, conditions, pageNo, pageSize, sort, callback);
}
exports.getAllOperationByFid = function(conditions, pageNo, pageSize, sort, callback) {
    getAllOperationByFidHelp(conditions, pageNo, pageSize, sort, callback);
};

function getAllOperationByFidHelp(conditions, pageNo, pageSize, sort, callback) {
    countAllByFid(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            var skip = (pageNo - 1) * pageSize;
            var limit = count - skip > pageSize ? pageSize : (count - skip);
            var sortBy = '-created';
            if (sort) {
                sortBy = sort;
            }
            
            ForumModerator.find(conditions).populate('info').limit(limit).skip(skip).sort(sortBy).exec(function(err, docs) {
                if (err) {
                    console.error(err);
                    callback(err,null);
                } else {
                    var obj={};
                    obj.total=count;
                    obj.pageNo=pageNo;
                    obj.pageSize=pageSize;
                    obj.items=docs;
                    callback(null,obj);
                }
            });
     
        }
    });
}
//获取数量
function countAllByFid(conditions, callback) {
    ForumModerator.count(conditions, function(err, count) {
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            callback(null, count);
        }
    });
}
function getAllOperationByFidHelpAndNickName(userName, conditions, pageNo, pageSize, sort, callback){
   
     conditions.userName = {
        $regex:userName,
        $options:'i'
    };
    countAllByFid(conditions, function(err, count) {
        console.log(count);
        if (err) {
            console.error(err);
            callback(err, null);
        } else {
            var skip = (pageNo - 1) * pageSize;
            var limit = count - skip > pageSize ? pageSize : (count - skip);
            var sortBy = '-created';
            if (sort) {
                sortBy = sort;
            }
            ForumModerator.find(conditions).populate('info').limit(limit).skip(skip).sort(sortBy).exec(function(err, docs) {
                if (err) {
                    console.error(err);
                    callback(err, null);
                } else {                   
                    var obj = {};
                    obj.total = count;
                    obj.pageNo = pageNo;
                    obj.pageSize = pageSize;
                    obj.items = docs;
                    console.log(docs);
                    callback(null, obj);
                }
            });
        }
    });
}