'use strict';
var mongoose = require('mongoose');
var ForumOptions = mongoose.model('ForumOptions');
var optionsKey = require('../utils/optionsKey')

//设置轮播图
exports.setShuffling=function(ent_code,value,callback){
	ForumOptions.find({ent_code:ent_code,key:optionsKey.shuffling}, null, {},function(err,docs){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			if(err){
				console.error(err);
				callback(err,null);
			}else{
				if(docs && docs.length>0){
					var entity=docs[0];
					ForumOptions.update({ _id: entity._id}, {value:value},null,function(err,result){
						if (err) {
							console.error(err);
							callback(err,null);
						} else {
							callback(null,null);
						}
					});
				}else{
					var forum = new ForumOptions({ent_code:ent_code,key:optionsKey.shuffling,value:value});
					forum.save(function(err, forum) {
						if (err) {
							console.error(err);
							callback(err,null);
						} else {
							callback(null,forum);
						}
					});
				}
			}
		}
	});
};

//获取轮播图
exports.getShuffling=function(ent_code,callback){
	ForumOptions.find({ent_code:ent_code,key:optionsKey.shuffling}, null, {},function(err,docs){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			if(err){
				console.error(err);
				callback(err,null);
			}else{
				if(docs && docs.length>0){
					callback(null,docs[0].value);
				}else{
					callback(null,null);
				}
			}
		}
	});
};


