'use strict';
var mongoose = require('mongoose');
var ForumPraiseLog = mongoose.model('ForumPraiseLog');

//创建点赞日志
exports.createPraiseLog=function(entity,callback){
	var forum = new ForumPraiseLog(entity);
	forum.save(function(err, forum) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,forum);
		}
	});
};

exports.queryPraiseLog=function(tid,cid,user,type,callback){
	var conditions={
		user:user,
		thread:tid,
		type:type
	};
	if(cid){
		conditions.comment=cid;
	}
	ForumPraiseLog.findOne(conditions).sort({created : -1}).exec(function(err,docs){
		if(err){
			callback(err,null);
		}else{
			callback(null,docs);
		}
	});
};

//更新
exports.updatePraiseLog=function(id, status,callback){
	ForumPraiseLog.findOneAndUpdate({
        _id: id
    }, {
        status: status
    }, function(err, doc) {
        if (err) {
            callback(err, null);
        } else {
            callback(null, doc);
        }
    });
};


exports.queryPraiseLogV2=function(conditions,callback){
	ForumPraiseLog.find(conditions).populate('user').exec(function(err,docs){
		if(err){
			callback(err,null);
		}else{
			callback(null,docs);
		}
	});
};


exports.queryPraiseLogV3=function(conditions,callback){
	ForumPraiseLog.find(conditions).exec(function(err,docs){
		if(err){
			callback(err,null);
		}else{
			callback(null,docs);
		}
	});
};
