'use strict';
var mongoose = require('mongoose');
var ForumRolePermission = mongoose.model('ForumRolePermission');

//获取数量
function countAll(ent_code,callback) {
	ForumRolePermission.count({ent_code:ent_code}, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

function getAllRolePermissionData(ent_code,pageNo,pageSize,callback){
	countAll(ent_code,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);
		    ForumRolePermission.find({ent_code:ent_code}).skip(skip).limit(limit).sort('created').populate('role').exec(function(err,docs){
		    	if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;
					callback(null,obj);
				}
		    });
		 //    ForumRolePermission.find({ent_code:ent_code}, null, {skip: skip,limit:limit},function(err,docs){
				
			// });
		}
	});
}

//获取全部列表数据
exports.getAllRolePermission= function(ent_code,pageNo,pageSize,callback) {
	getAllRolePermissionData(ent_code,pageNo,pageSize,function(err,results){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,results);
		}
	});
};

//获取用户角色对应的操作权限
function getRolePermiss(ent_code,integral,exp,callback){
	//2.获取角色权限列表
	getAllRolePermissionData(ent_code,1,10,function(err,docs){
		if(err){
			callback(err,null);
		}else{
			//3.根据积分、经验匹配对应的角色
			var obj={};
			var items=docs.items;
			for(var i=0;i<items.length;i=i+1){
				var rolePermission=items[i];
				var rules=rolePermission.rules;
				if(rules && rules.length>0){
					for(var j=0;j<rules.length;j=j+1){
						var json=rules[j];
						// console.log(json);
						// json= {value: '1-2', key: 'integral' }
						// json=JSON.parse(json);
						var key=json.key;
						var value=json.value;
						if(value && value!==''){
							var defaultValue=0;
							if(key==='integral'){//积分
								defaultValue=integral;
							}else if(key==='exp'){//经验
								defaultValue=exp;
							}
							var array=value.split('-');
							var ge=array[0];
							var le=array[1];
							var result=true;
							var isMatch=0;
							// console.log(defaultValue);
							if(ge && ge!==''){
								isMatch=1;
								result=Number(defaultValue)>=Number(ge);
							}
							if(result && le && le!==''){
								isMatch=1;
								result=Number(defaultValue)<=Number(le);
							}
							if(result && isMatch===1){
								obj=rolePermission;
								callback(null,obj);
								return;
							}
						}
					}
				}
			}
			callback(null,obj);
		}
	});
}

//检查是否有操作权限
exports.checkRolePermiss=function(ent_code,action,integral,exp,callback){
	//1.获取用户角色权限
	getRolePermiss(ent_code,integral,exp,function(err,rolePermission){
		if(err){
			callback(err,null);
		}else{
			var result=false;
			//2.检查用户对应的角色是否有对应的操作权限
			if(rolePermission && rolePermission.permission){
				var permissions=rolePermission.permission;
				for(var i=0;i<permissions.length;i=i+1){
					// var obj=JSON.parse(permissions[i]);
					var obj=permissions[i];
					var tmpAction=obj.action;
					var value=obj.value;
					if(tmpAction===action){
						if(value==='1'){
							result=true;
							break;
						}
					}
				}
			}
			callback(null,result);
		}
	});
};