'use strict';
var mongoose = require('mongoose');
var ForumTag = mongoose.model('ForumTag');

//创建
exports.createTag=function(entity,callback){
	var forum = new ForumTag(entity);
	forum.save(function(err, forum) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,forum);
		}
	});
};

//根据ID获取论坛板块
exports.getTagById=function(tid,callback){
	ForumTag.findById(tid, function(err, tag) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,tag);
		}
	});
};

//根据ID更新论坛板块
exports.updateTagById=function(tid,entity,callback){
	ForumTag.update({ _id: tid}, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//根据ID删除标签
exports.deleteTagById=function(tid,callback){
	ForumTag.remove({ _id: tid},function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//获取数量
function countAll(conditions,callback) {
	ForumTag.count(conditions, function (err, count) {
	   if(err){
	   		console.error(err);
			callback(err,null);
	   }else{
	   		callback(null,count);
	   }
	});
}

//获取全部列表数据
exports.getAllTag= function(conditions,pageNo,pageSize,callback) {
	countAll(conditions,function(err,count){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			var skip = (pageNo - 1) * pageSize;
		    var limit = count - skip > pageSize ? pageSize : (count - skip);
		    ForumTag.find(conditions, null, {skip: skip,limit:limit,sort:{order_idx:-1},populate:'info'},function(err,docs){
				if (err) {
					console.error(err);
					callback(err,null);
				} else {
					var obj={};
					obj.total=count;
					obj.pageNo=pageNo;
					obj.pageSize=pageSize;
					obj.items=docs;
					callback(null,obj);
				}
			});
		}
	});
};

exports.getAllOrderIDX=function(conditions,callback){
	ForumTag.find(conditions).select('_id order_idx').sort({order_idx:-1}).exec(function(err, docs) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,docs);
		}
	});
};

//修改序号
exports.updateTagIdx=function(id,idx,callback){
	ForumTag.update(
	{_id:id},
	{ order_idx: idx },
	null,
	function(err,result){
		if(err){
			console.error(err);
			callback(err,null);
		}else{
			callback(null,true);
		}
	});
};

