'use strict';
//模型
var mongoose = require('mongoose'),
    then = require('thenjs');

var ForumThread = mongoose.model('ForumThread'),
    ForumThreadAttend = mongoose.model('ForumThreadAttend'),
    ForumComment = mongoose.model('ForumComment'),
    ForumUser = mongoose.model('ForumUser');

var forumUserService = require('./forumUserService');
var forumCommentService = require('./forumCommentService');

//创建或更新
exports.threadAttend=function(tid,uid,callback){
    then.parallel([
        function(cont){
            ForumThread.findById(tid,function(err,doc){
                cont(err,doc);
            });
        },
        function(cont){
            ForumThreadAttend.findOne({thread:tid},function(err,doc){
                cont(err,doc);
            });    
        }
    ]).then(function(cont,results){
        var thread = results[0],
            attend = results[1];
        if(!thread){
            cont('thread not exits');
        }else if(!attend){
            //创建记录
            var entity = {
                thread:tid,
                info:thread.info,
                from:thread.from,
                attend:[],
                total:0
            }
            var forum = new ForumThreadAttend(entity);
            forum.save(function(err, newAttend) {
                cont(err,thread,newAttend);
            });
        }else{
            cont(null,thread,attend);
        }    
    }).then(function(cont,thread,attend){
        ForumThreadAttend.findOne({_id:attend._id,attend:uid},function(err,doc){
            cont(err,doc);
        });
    }).then(function(cont,attend){
        if(attend){
            callback(null,true);
        }else{
            ForumThreadAttend.findOneAndUpdate({thread:tid},{updated:new Date(),$push:{attend:uid}},function(err,doc){
                    callback(err,err?false:true);
            });
        }
    }).fail(function(cont,err){
        console.error(err);
        callback(err);
    });
    
};
//根据发帖者分页查询话题列表
exports.findMyAttentByPage = function(conditions,pageNo, pageSize,sort,callback) {
    then(function(cont) {
        ForumThreadAttend.find(conditions).count(cont);
    }).then(function(cont, count) {
        var skip = (pageNo - 1) * pageSize;
        var limit = count - skip > pageSize ? pageSize : (count - skip);
        ForumThreadAttend.find(conditions).skip(skip).limit(limit).sort(sort || '-updated').exec(function(err, docs) {
            cont(err, count, docs);
        });
    }).then(function(cont, count, threads) {
        var rsJson = {
            result: true,
            total: count,
            datas: threads
        };
        callback(null, rsJson);

    }).fail(function(cont, err) {
        console.error(err);
        var rsJson = {
            result: false,
            err: err
        };
        callback(err, rsJson);
    });
};




