'use strict';
var mongoose = require('mongoose');
var ForumUser = mongoose.model('ForumUser');
var then = require('thenjs');
var async = require('async');
// var forumLimitActionRefService = require('../service/forumLimitActionRefService');
// var forumLimitActionConfigService = require('../service/forumLimitActionConfigService');

var forumLimitOperationService = require('../service/forumLimitOperationService');

//创建用户
exports.createUser=function(entity,callback){
	var forum = new ForumUser(entity);
	forum.save(function(err, forum) {
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,forum);
		}
	});
};

//根据Uid获取用户
exports.getUserByUid=function(uid,callback){
	ForumUser.findOne({uid:uid}).exec(function(err,result){
		if(err){
			callback(err,null);
		}else{
			if(result ){
				callback(null,result);
			}else{
				callback(null,null);
			}
		}
	});
};

//根据id获取用户
exports.getUserById=function(id,callback){
	ForumUser.findOne({_id:id}).exec(function(err,result){
		if(err){
			callback(err,null);
		}else{
			if(result ){
				callback(null,result);
			}else{
				callback(null,null);
			}
		}
	});
};

//根据ID更新用户信息
exports.updateUserById=function(uid,entity,callback){
	ForumUser.update({ _id: uid}, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};

//查询用户信息
exports.searchMembers=function(pageNo, pageSize, q, callback){
	then(function(cont) {
        ForumUser.find(q).count(cont);
    }).then(function(cont, count) {
        var skip = (pageNo - 1) * pageSize;
        var limit = count - skip > pageSize ? pageSize : (count - skip);
        ForumUser.find(q).skip(skip).limit(limit).sort('-created').exec(function(err, docs) {
            cont(err, count, docs);
        });
    }).then(function(cont, count, members) {
        var rsJson = {
            result: true,
            total: count,
            datas: members
        };
        callback(null, rsJson);
    }).fail(function(cont, err) {
        console.error(err);
        var rsJson = {
            result: false,
            err: err
        };
        callback(err, rsJson);
    });
};

//根据nickName查询用户
exports.searchMembersByNickName=function(nickName, callback){
	var name = {
		$or : [
			{nickName : { $regex: nickName, $options: 'i' }},
			{displayName : { $regex: nickName, $options: 'i' }}
		]
	};
    ForumUser.find(name).exec(function(err,result){
		if(err){
			callback(err,null);
		}else{
			callback(null,result);
		}
	});
};

//根据mid查询用户
exports.searchMembersByMid=function(mid, callback){
    ForumUser.find({mid:mid}).exec(function(err,result){
		if(err){
			callback(err,null);
		}else{
			callback(null,result);
		}
	});
};

//查询用户和行为限制信息
exports.searchMembersAndLimitActions=function(pageNo, pageSize, q, callback){
	then(function(cont) {
        ForumUser.find(q).count(cont);
    }).then(function(cont, count) {
        var skip = (pageNo - 1) * pageSize;
        var limit = count - skip > pageSize ? pageSize : (count - skip);
        ForumUser.find(q).skip(skip).limit(limit).sort('-created').exec(function(err, docs) {
            cont(err, count, docs);
        });
    }).then(function(cont, count, members) {
    	if (count > 0) {
	        var asyncTasks = [];
	        members.forEach(function(member) {
	            asyncTasks.push(function(callback) {
	            	forumLimitOperationService.getLimitOperationByUserId(member._id, function(err, forumLimitOperation) {
			            if (err) {
	                        console.error(err);
	                        callback(null, null);
	                    } else {
	                    	if(forumLimitOperation){
	                    		var limit_actions = forumLimitOperation.limit_actions;
		                    	var array = [];
				                for (var i = 0; i < limit_actions.length; i += 1) {
				                    var limit_action = limit_actions[i];
				                    var name = '';
				                    switch(limit_action.limit_type)
									{
										case 1:
										  name = '禁言';
										  break;
										case 2:
										  name = '不加积分';
										  break;
									}
									array.push(name);
				                }
				                member = member.toObject();
				                member.limitActions = array;
				                callback(null, member);
	                    	}else{
	                    		callback(null, member);
	                    	}
	                    }
			        });
	            });
	        });
	        async.parallel(asyncTasks, function(err, results) {
	            if (err) {
	                console.log(err);
	                callback(null, null);
	            } else {
	                var rsJson = {
			            result: true,
			            total: count,
			            datas: results
			        };
			        callback(null, rsJson);
	            }
	        });

	    } else {
	        var rsJson = {
	            result: true,
	            total: count,
	            datas: members
	        };
	        callback(null, rsJson);
	    }
    }).fail(function(cont, err) {
        console.error(err);
        var rsJson = {
            result: false,
            err: err
        };
        callback(err, rsJson);
    });
};


//根据UID和entCode更新用户信息
exports.updateUserByUIdAndEntCode=function(uid,ent_code,entity,callback){
	ForumUser.update({
		uid: uid,
		ent_code:ent_code
	}, entity,null,function(err,result){
		if (err) {
			console.error(err);
			callback(err,null);
		} else {
			callback(null,null);
		}
	});
};
