'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');

var mongoose = require('mongoose');
var moment = require('moment');
var ForumThread=require('../../models/forumThread');
var forumUserService=require('../../service/forumUserService');
var forumThreadService=require('../../service/forumThreadService');
var httpService=require('../../service/httpService');

var forumLimitOperationService=require('../../service/forumLimitOperationService');

var async=require('async');

var user=require('../../utils/user');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//格式化日期 (格式：年-月-日)
function date_format(date) {
    return moment(date).format('YYYY-MM-DD');
}

//判断时间是否在指定范围
function compareTime(now, begin_time, end_time) {
    var begin_time = new Date(begin_time).getTime(),
		ent_time = new Date(end_time).getTime(),
		this_now = new Date(now).getTime();
	if(this_now >= begin_time && this_now <= ent_time){
		return true;
	}else{
		return false;
	}
}

var updateUser = function(user,entity){
	var updateObj = {},
		isUpdate = false;	
	if(user && entity && user._id){
		if(entity.nickName && user.nickName !== entity.nickName){ 
			updateObj.nickName = entity.nickName;
			isUpdate = true;
		}

		if(entity.icon && user.icon !== entity.icon){
			updateObj.icon = entity.icon;
			isUpdate = true;
		}

		if(entity.mid && !user.mid){
			updateObj.mid = entity.mid;
			isUpdate = true;
		}

		if(isUpdate){
			forumUserService.updateUserById(user._id,updateObj,function(err,result){
				if(err){
					console.log(err);
				}else{
					console.log('用户:'+user._id+'---------更新成功');
					// console.log(updateObj);
				}
			});
		}
	}	
}
//验证用户身份
// router.post('/user/identifyUser',function(req,res,next){
// 	var entity=req.body;
// 	if(req.session.mobileForumUser && req.session.mobileForumUser.openId === entity.openId){
// 		res.json({result:'success',userId:req.session.mobileForumUser.userId});
// 	}else if(!req.session.mobileForumUser || req.session.mobileForumUser.openId !== entity.openId){
// 			forumUserService.getUserByUid(entity.uid,function(err,doc){
// 				if(err){
// 					console.error(err);
// 					res.json('error');
// 				}else{
// 					if(doc){
// 						updateUser(doc,entity);	
// 						req.session.mobileForumUser={
// 							userId:doc._id,
// 							openId:doc.uid,
// 							mid:doc.mid || entity.mid
// 						};
// 						res.json({result:'success',userId:doc._id});
// 					}else{
// 						forumUserService.createUser(entity,function(err,doc){
// 							if(err){
// 								console.error(err);
// 								res.json('error');
// 							}else{
// 								req.session.mobileForumUser={
// 									userId:doc._id,
// 									openId:doc.uid,
// 									mid:doc.mid
// 								};
// 								res.json({result:'success',userId:doc._id});
// 							}
// 						});
// 					}
// 				}
// 			});
// 	}else{
// 		res.json({result:'success',userId:req.session.mobileForumUser.userId});
// 	}
// });

//验证用户身份
router.post('/user/identifyUser',function(req,res,next){
	var entity=req.body;
	if(entity){
		forumUserService.getUserByUid(entity.uid,function(err,doc){
			if(err){
				console.error(err);
				res.json('error');
			}else{
				if(doc){
					updateUser(doc,entity);	
					req.session.mobileForumUser={
						userId:doc._id,
						openId:doc.uid,
						mid:doc.mid || entity.mid
					};
					res.json({result:'success',userId:doc._id});
				}else{
					forumUserService.createUser(entity,function(err,doc){
						if(err){
							console.error(err);
							res.json('error');
						}else{
							req.session.mobileForumUser={
								userId:doc._id,
								openId:doc.uid,
								mid:doc.mid
							};
							res.json({result:'success',userId:doc._id});
						}
					});
				}
			}
		});
	}else{
		res.json({result:'success',userId:req.session.mobileForumUser.userId});
	}
});
//微信分享带来用户
router.get('/user/from/share', function(req, res, next) {
	// var userId = req.session.mobileForumUser.userId;

    var mid = req.query.mid,
        action = req.query.action,
        ent_code = req.query.ent_code;

    // forumLimitOperationService.checkLimitOperationProhibitionAddIntegral(userId, function(err, flag){
    // 	if(err){
    // 		console.error(err);
    //         res.json(returnCode.PROHIBITION_OF_SPEECH);
    // 	}else{
    // 		if(flag){
    //             res.json(returnCode.PROHIBITION_OF_SPEECH);
    // 		}else{
    			httpService.sendRequest(ent_code,mid,action);
    			res.status(200).end();
    // 		}
    // 	}
    // });
});

//检查用户权限  旧版
router.post('/user/checkLimitAction', function(req, res, next) {
	var userId = req.body.userId;
	if(userId){
		var array = [];

		var configs = [{
			code:'forum_prohibition_of_speech'
		},{
			code:'forum_not_add_integral'
		}];
		forumLimitOperationService.getLimitOperationByUserId(userId,function(err,forumLimitOperation){
			if (err) {
				console.error(err);

				var returnObject = {
                	errcode:'-1',
                	errmsg:err,
                	configs:configs,
                	data:array
                }
                res.json(returnObject);
			} else {
				// 获取到用户行为限制记录
				if(forumLimitOperation){
					var limit_actions = forumLimitOperation.limit_actions;
	                for (var i = 0; i < limit_actions.length; i += 1) {
	                    var limit_action = limit_actions[i];
	                    var flag = compareTime(new Date(), limit_action.begin_time, limit_action.end_time);
	                    //把flag和limit_action_type 放进session
	                    var code = '';
	                    switch(limit_action.limit_type)
						{
							case 1:
							  code = 'forum_prohibition_of_speech';
							  break;
							case 2:
							  code = 'forum_not_add_integral';
							  break;
						}

	                    var obj = {
	                    	result : flag,
	                    	code : code
	                    }
	                    array.push(obj);
	                }
	                var returnObject = {
	                	errcode:'success',
	                	configs:configs,
	                	data:array
	                }
	                res.json(returnObject);
				}else{
					var returnObject = {
	                	errcode:'success',
	                	configs:configs,
	                	data:[]
	                }
					res.json(returnObject);
				}
			}
		});
	}else{
		var returnObject = {
        	errcode:'-1',
        	errmsg:'参数错误',
        	data:[]
        }
		res.json(returnObject);
	}
});
