'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	moment = require('moment'),
    mongoose = require('mongoose'),
	_ = require('lodash'),
	then = require('thenjs');

var forumSuggestionService=require('../../service/forumSuggestionService');


var user=require('../../utils/user');

module.exports = function(app) {
	app.use('/v1/forum', router);
};

//新增
router.post('/suggestion/create', function(req, res, next) {
    var userId = user.getMobileUser(req);
    var ent_code = req.session.user.ent_code;
    var object = req.body;
    object.from = userId;
    object.ent_code = ent_code;
    if(userId && object){
        forumSuggestionService.create(object,function(err,doc){
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(returnCode.SUCCESS);
            }
        });
    }else{
        res.json(returnCode.WRONG_PARAM);
    }
});