'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');
var mongoose = require('mongoose');
var ForumGroup = mongoose.model('ForumGroup');
var ForumInfo = mongoose.model('ForumInfo');

var forumGroupService=require('../../service/forumGroupService');
var forumInfoService=require('../../service/forumInfoService');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//新增论坛组
router.post('/group/create', function(req, res, next) {
	var rs = {};
	req.body.ent_code=req.session.user.ent_code;
	forumGroupService.createGroup(req.body,function(err,group){
		if (err) {
			console.error(err);
			res.json(returnCode.BUSY);
		} else {
			rs.data = {'id':group._id};
			res.json(_.assign(rs, returnCode.SUCCESS));
		}
	});
});

//
router.post('/group/:gid/update', function(req, res, next) {
	var rs = {};
	var gid=req.params.gid;
	if(gid){
		forumGroupService.updateGroupById(gid,req.body,function(err,group){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
	
});

//
router.post('/group/:gid/delete', function(req, res, next) {
	var gid=req.params.gid;
	if(gid){
		forumGroupService.deleteGroupById(gid,function(err,result){
			if(err){
				res.json(returnCode.BUSY);
			}else{
				res.json(returnCode.SUCCESS);
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});

//获取目标论坛组信息
router.get('/group/:gid/info', function(req, res, next) {
	var gid = req.params.gid || null;
	var rs = {};

	if (gid) {
		forumGroupService.getGroupById(gid,function(err,group){
			if (err) {
				console.error(err);
				res.json(returnCode.BUSY);
			} else {
				rs.data = group;
				res.json(_.assign(rs, returnCode.SUCCESS));
			}
		});

	} else {
		res.json(returnCode.WRONG_PARAM);
	}
});

/**
 * 获取论坛组列表
 * @param  {[type]} req   [description]
 * @param  {[type]} res   [description]
 * @param  {[type]} next) {	var        pageNo [description]
 * @return {[type]}       [description]
 */
router.get('/group/list', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

    var groupName=req.query.groupName;

    var conditions={
    	ent_code:req.session.user.ent_code
    };

    if(groupName){
    	conditions.name = {
			$regex: groupName,
			$options: 'i'
		};
    }

	forumGroupService.getAll(conditions,pageNo,pageSize,function(err,results){
		if(err){
			console.error(err);
			res.json(returnCode.BUSY);
		}else{
			res.json(_.assign(results, returnCode.SUCCESS));
		}
	});
});

/**
 * 获取板块列表
 * @param  {[type]} req   [description]
 * @param  {[type]} res   [description]
 * @param  {[type]} next) {	var        pageNo [description]
 * @return {[type]}       [description]
 */
router.get('/group/:gid/forumInfos', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var gid=req.params.gid;

	if(gid){
		forumInfoService.getAllByGid(req.session.user.ent_code,gid,pageNo,pageSize,function(err,results){
			if(err){
				console.error(err);
				res.json(returnCode.BUSY);
			}else{
				res.json(_.assign(results, returnCode.SUCCESS));
			}
		});
	}else{
		res.json(returnCode.WRONG_PARAM);
	}
});