'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');

var forumLimitOperationLogService = require('../../service/forumLimitOperationLogService');

module.exports = function(app) {
    app.use('/admin/forum', router);
};

//根据userId获取论坛行为限制
router.get('/limitOperationLogs/get/:userId', function(req, res, next) {
    var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var userId = req.params.userId;
    var ent_code = req.session.user.ent_code;
    if (userId && ent_code) {
        var conditions = {
            ent_code:ent_code,
            userId:userId
        }
        forumLimitOperationLogService.getAllLimitAction(conditions, pageNo, pageSize, function(err, results) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(_.assign(results, returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});
