'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');
var mongoose = require('mongoose');
var ForumThread = mongoose.model('ForumThread');
var forumThreadService = require('../../service/forumThreadService');
var forumRolePermissionService = require('../../service/forumRolePermissionService');
var forumPraiseLogService = require('../../service/forumPraiseLogService');
var forumShareLogService = require('../../service/forumShareLogService');
var forumCommentService = require('../../service/forumCommentService');
var forumTagService = require('../../service/forumTagService');
var forumUserService = require('../../service/forumUserService');
var forumUserHonorTimeLineService = require('../../service/forumUserHonorTimeLineService');
var redisThreadList = require('../../utils/redisThreadList');

var httpService = require('../../service/httpService');

var userUtil = require('../../utils/user');
var async = require('async');
var _ = require('lodash');
var then = require('thenjs');
returnCode = require('../../utils/returnCode');

var request=require('request');
var env = process.env.NODE_ENV;
var API_ADDRESS='http://localhost:8080';
if(env == 'sandbox'){
    API_ADDRESS='http://rest.wxpai.cn';
}else if(env == 'production'){
    API_ADDRESS='https://rest.wxpai.cn';
}

module.exports = function(app) {
    app.use('/admin/forum', router);
};


//---------------------文章表单操作---------------------------------

//获取用户列表
router.post('/member/searchMembers', function(req, res, next) {
    var pageNo = req.body.pageNo,
        pageSize = req.body.pageSize,
        ent_code = req.session.user.ent_code,
        search = req.body.search;
    if (pageNo && pageSize) {
        var q = {
            ent_code: ent_code
        };
        if (search.nickName) {

            q.nickName = {
                $regex: search.nickName
            };
        }
        if(search.mid){
            q.mid = search.mid;
        }
        if (search.displayName) {
            q.displayName = {
                $regex: search.displayName
            };
        }
        if (search.sex !== 3) {
            q.sex = search.sex;
        }
        if (search.status) {
            q.status = search.status;
        }
        if (search.honorTitleId) {
            q.honorTitles = {
                $in: [search.honorTitleId]
            };
        }
        forumUserService.searchMembersAndLimitActions(pageNo, pageSize, q, function(err, results) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(results);
            }
        });
    } else {
        console.error('params error');
        res.json({
            result: false,
            err: 'params error'
        });
    }
});

//获取单用户
router.get('/member/:mid/get', function(req, res, next) {
    var mid = req.params.mid || null;
    if (mid) {
        forumUserService.getUserById(mid, function(err, user) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                var obj = {
                    result : true,
                    data : user
                }
                res.json(obj);
            }
        });
    } else {
        console.error('params error');
        res.json({
            result: false,
            err: 'params error'
        });
    }
});


//根据uid获取mid
router.get('/member/getMidByUid/:uid', function(req, res, next) {
    var uid = req.params.uid || null;
    var ent_code = req.session.user.ent_code;
    if (uid) {
        request.get({url:API_ADDRESS+'/v1.0/internal/member/getMidbyOpenID?entCode='+ent_code+'&openID='+uid,json:true},function(e,r,result){
            if(result && result.data){
                res.json({
                    errcode:0,
                    data: result.data,
                    errmsg: 'success'
                });
            }else{
                res.json({
                    errcode:-1,
                    data: null,
                    errmsg: 'null'
                });
            }
        });
    } else {
        console.error('params error');
        res.json({
            result: false,
            err: 'params error'
        });
    }
});


//更新
router.post('/member/:mid/update', function(req, res, next) {
    var mid=req.params.mid;
    var entity = req.body;
    if(mid && entity){
        forumUserService.updateUserById(mid,entity,function(err,result){
            if(err){
                res.json(returnCode.BUSY);
            }else{
                res.json(returnCode.SUCCESS);
            }
        });
    }else{
        res.json(returnCode.WRONG_PARAM);
    }
});

//获取用户收藏记录
router.get('/member/:uid/favors', function(req, res, next) {
    var uid = req.params.uid || null;
    var ent_code = req.session.user.ent_code;
    if (uid) {
        var condition = {
            _id : uid,
            ent_code : ent_code
        }
        forumUserService.getFavors(condition,function(err,result){
            if(err){
                console.log(err);
                res.json(returnCode.BUSY);
            }else{
                var rs ={data : result};
                res.json(_.assign(rs, returnCode.SUCCESS));
            }
        });
    } else {
        console.error('params error');
        res.json({
            result: false,
            err: 'params error'
        });
    }
});


//设置荣誉头衔
router.post('/member/:mid/setHonorTitle', function(req, res, next) {
    var mid=req.params.mid;
    var entity = req.body;
    var ent_code = req.session.user.ent_code;
    //荣誉列表
    var honorList = entity.honorTitles;

    //需要添加的荣誉
    var addHonorList = [];

    //需要移除的荣誉
    var removeHonorList = [];
    async.waterfall([
        function(callback) {
            //获取已有头衔
            forumUserService.getUserById(mid, function(err, user) {
                callback(err, user);
            });
        },
        function(user, callback) {
            if(user && user.honorTitles && user.honorTitles.length > 0){
                var exitsHonorList = user.honorTitles;
                for(var i = 0;i < exitsHonorList.length; i++){ 
                    var flag = true;
                    for(var j = 0; j < honorList.length; j++){
                        if(exitsHonorList[i]._id.toString() == honorList[j]){ //相等
                            flag = false;
                            break;
                        }
                    }
                    if(flag){ //获取需要删除的
                        removeHonorList.push(exitsHonorList[i]._id);
                    }
                } 

                for(var k = 0; k < honorList.length; k++){ 
                    var add_flag = true;
                    for(var l = 0; l < exitsHonorList.length; l++){
                        if(honorList[k].toString() == exitsHonorList[l]._id.toString()){ //相等
                            add_flag = false;
                            break; 
                        }
                    }
                    if(add_flag){ //获取需要添加的
                        addHonorList.push(honorList[k]);
                    }
                } 
            }else{
                addHonorList = honorList;
            }

            //设置头衔头衔
            forumUserService.updateUserById(mid,entity,function(err,result){
                callback(err, result);
            });
        },
        function(list, callback) { //插入时间线
            var asyncTasks = [];
            _.forEach(addHonorList, function(one, i) {
                asyncTasks.push(function(cont) {
                    var model = {
                        ent_code: ent_code,
                        user: mid,
                        honor: one
                    };
                    forumUserHonorTimeLineService.create(model,function(err,entity){
                        if (err) {
                            console.error(err);
                            cont(err, null);
                        } else {
                            cont(null, entity);
                        }
                    });
                });
            });
            then.parallel(asyncTasks).then(function(cont, datas) {
                callback(null, null);
            }).fail(function(err, cont) {
                callback(err, null);
            });
        },
        function(user, callback) {
            var condition = {
                user:mid,
                honor:{$in:removeHonorList}
            }

            //设置头衔头衔
            forumUserHonorTimeLineService.deleteByCondition(condition,function(err,result){
                callback(err, result);
            });
        }
    ], function(err, result) {
        if (err) {
            console.error(err);
            res.json(returnCode.BUSY);
        } else {
            res.json(returnCode.SUCCESS);
        }
    });
});

