'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash'),
	moment = require('moment'),
	nodeExcel = require('excel-export'),
	then = require('thenjs');

var mongoose = require('mongoose');

var forumModeratorService=require('../../service/forumModeratorService');
var ForumModerator = mongoose.model('ForumModerator'),
    ForumPVLog = mongoose.model('ForumPVLog');

module.exports = function(app) {
	app.use('/admin/forum', router);
};

//操作记录列表
router.get('/moderator/list', function(req, res, next){
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;
    var infoId = req.query.infoId;
    var content = req.query.content;
    var userName = req.query.userName;
    var moderatorName=req.query.moderatorName;
    var behavior=req.query.behavior;
    var begin = req.query.begin;
    var end = req.query.end;
    var conditions = {
        ent_code: req.session.user.ent_code
    };
    if (infoId) {        
        conditions.info = infoId;
    }    
   
    if (content) {
        conditions['content.content'] = {
                $regex:content,
                $options:'i'
        };
    }

    if(begin || end){
        conditions.created = {};
        if(begin){
            conditions.created['$gte'] = new Date(begin);
        }
        if(end){
            var t = new Date(end);
            t.setDate(t.getDate() + 1);
            conditions.created['$lte'] = t;
        }
    }
    if(behavior)
    {
        conditions.behavior=behavior;
    }
    if(userName){
        forumModeratorService.getAllOperationByFidAndNickName(userName, conditions, pageNo, pageSize, null, function(err, results) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                   res.json(_.assign(results, returnCode.SUCCESS));
            }
        });
    }else
    {
       forumModeratorService.getAllOperationByFid(conditions, pageNo, pageSize, null, function(err, results) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(_.assign(results, returnCode.SUCCESS));
            }
        });
    }
})