'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    _ = require('lodash');
var mongoose = require('mongoose');
var async = require('async');

var forumModeratorApplyService = require('../../service/forumModeratorApplyService');
var forumUserService = require('../../service/forumUserService');

module.exports = function(app) {
    app.use('/admin/forum', router);
};

//设置版主
router.post('/forumModeratorApply/create', function(req, res, next) {
    var ent_code = req.session.user.ent_code;
    var fuserId = req.body.uid;
    if (fuserId) {
        forumModeratorApplyService.getForumModeratorApplyByFUserId(fuserId, function(err, doc) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else if (doc) { //已申请
                res.json({
                    errorcode: 0,
                    errormsg: '已申请,请勿重复申请!'
                });
            } else {
                var conditions = {
                    ent_code: ent_code,
                    forumUser: fuserId
                }
                var model = {
                    ent_code: ent_code,
                    forumUser: fuserId,
                    status: 1
                };
                forumModeratorApplyService.createOrUpdateLimitOperation(conditions, model, function(err, ModeratorApply) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        res.json(_.assign(returnCode.SUCCESS));
                    }
                });
            }
        })
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});


//新增或更新
router.post('/forumModeratorApply/createOrUpdate', function(req, res, next) {
    var ent_code = req.session.user.ent_code;
    var fuserId = req.body.fuserId;
    var infoIds = req.body.infoIds;
    if (fuserId) {
        var conditions = {
            ent_code: ent_code,
            forumUser: fuserId
        }

        var model = {
            ent_code: ent_code,
            forumUser: fuserId,
            infoIds: infoIds,
            status:1
        };
        forumModeratorApplyService.createOrUpdateLimitOperation(conditions, model, function(err, ModeratorApply) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(_.assign(returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//更新
router.post('/forumModeratorApply/updateById', function(req, res, next) {
    var ent_code = req.session.user.ent_code;
    var id = req.body.id;
    var entity = req.body.entity;
    if (id && entity) {
        var conditions = {
            _id: id
        }
        forumModeratorApplyService.createOrUpdateLimitOperation(conditions, entity, function(err, ModeratorApply) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(_.assign(returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//根据userId获取
router.get('/forumModeratorApply/get/:fuserId', function(req, res, next) {
    var fuserId = req.params.fuserId;
    if (fuserId) {
        forumModeratorApplyService.getForumModeratorApplyByFUserId(fuserId, function(err, ModeratorApply) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                var rs = {};
                rs.data = ModeratorApply;
                res.json(_.assign(rs, returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//删除
router.post('/forumModeratorApply/delete/:id', function(req, res, next) {
    var id = req.params.id;
    if (id) {
        forumModeratorApplyService.deleteForumModeratorApplyById(id, function(err) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(_.assign(returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

//列表
router.post('/forumModeratorApply/list', function(req, res, next) {
    var pageNo = req.body.pageNo || 1;
    var pageSize = req.body.pageSize || 10;
    var search = req.body.search;

    var conditions = {
        ent_code: req.session.user.ent_code
    };

    if (search) {
        if (search.applyMsg) {
            conditions.applyMsg = {
                $regex: search.applyMsg
            };
        }
        if (search.status && Number(search.status) != 3) {
            conditions.status = Number(search.status);
        }
    }


    if (search.nickName) { //如果有用户昵称
        forumUserService.searchMembersByNickName(search.nickName, function(err, results) {
            if (err) {
                callback(err, null);
            } else {
                var mids = []
                if (results && results.length > 0) {
                    results.forEach(function(user) {
                        mids.push(user._id);
                    });
                }
                conditions.forumUser = {
                    $in: mids
                }
                forumModeratorApplyService.getForumModeratorApplys(conditions, pageNo, pageSize, null, function(err, results) {
                    if (err) {
                        console.error(err);
                        res.json(returnCode.BUSY);
                    } else {
                        res.json(_.assign(results, returnCode.SUCCESS));
                    }
                });
            }
        });
    } else {
        forumModeratorApplyService.getForumModeratorApplys(conditions, pageNo, pageSize, null, function(err, results) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(_.assign(results, returnCode.SUCCESS));
            }
        });
    }
});
