'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');

var ForumComplaintService=require('../../service/forumComplaintService');

module.exports = function(app) {
	app.use('/v1/forum', router);
};
//增加举报
router.post('/complaints', function(req, res, next) {
	var ent_code=req.session.user.ent_code;
	var uid = req.session.mobileForumUser.userId;
	ForumComplaintService.addComplaint(req.body,ent_code,uid,function(err,result){
		if(err){
			res.json(returnCode.UNCHECK_ERROR(err));
		}else{
			res.json(_.assign(result, returnCode.SUCCESS));
		}
	});
});