'use strict';
var express = require('express'),
    router = express.Router(),
    returnCode = require('../../utils/returnCode'),
    then = require('thenjs'),
    _ = require('lodash');

var mongoose = require('mongoose');
var forumModeratorApplyService = require('../../service/forumModeratorApplyService');
var user = require('../../utils/user');

module.exports = function(app) {
    app.use('/v1/forum', router);
};

//新增或更新
router.post('/forumModeratorApply/create', function(req, res, next) {
    var ent_code = req.session.user.ent_code;
    var fuserId = req.session.mobileForumUser.userId;
    var applyMsg = req.body.applyMsg;
    if (fuserId && applyMsg) {
        var conditions = {
            ent_code: ent_code,
            forumUser: fuserId
        }

        var model = {
            ent_code: ent_code,
            forumUser: fuserId,
            applyMsg: applyMsg
        };
        forumModeratorApplyService.createOrUpdateLimitOperation(conditions, model, function(err, ModeratorApply) {
            if (err) {
                console.error(err);
                res.json(returnCode.BUSY);
            } else {
                res.json(_.assign(returnCode.SUCCESS));
            }
        });
    } else {
        res.json(returnCode.WRONG_PARAM);
    }
});

