'use strict';
var express = require('express'),
	router = express.Router(),
	returnCode = require('../../utils/returnCode'),
	_ = require('lodash');
var mongoose = require('mongoose');
var ForumRolePermission = mongoose.model('ForumRolePermission');
var forumRolePermissionService=require('../../service/forumRolePermissionService');

module.exports = function(app) {
	app.use('/v1/forum', router);
};

//新增角色权限
router.post('/rolePermiss/create', function(req, res, next) {
	var rs = {};
	var form = {
		ent_code: req.session.user.ent_code
	};
	var group = new ForumRolePermission(_.assign(form, req.body));
	group.save(function(err, group) {
		if (err) {
			console.error(err);
			res.json(returnCode.BUSY);
		} else {
			rs.data = {'id':group._id};
			res.json(_.assign(rs, returnCode.SUCCESS));
		}
	});
});

//获取角色权限列表
router.get('/rolePermiss/list', function(req, res, next) {
	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

	var pageNo = req.query.pageNo || 1;
    var pageSize = req.query.pageSize || 10;

	forumRolePermissionService.getAllRolePermission(req.session.user.ent_code,pageNo,pageSize,function(err,docs){
    	if(err){
    		res.json(returnCode.BUSY);
    	}else{
			res.json(_.assign(docs, returnCode.SUCCESS));
    	}
    });
});

